/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspacedata.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.finspacedata.model.ChangesetSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListChangesetsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ChangesetSummary> changesets;
    private String nextToken;

    public List<ChangesetSummary> getChangesets() {
        return this.changesets;
    }

    public void setChangesets(Collection<ChangesetSummary> changesets) {
        if (changesets == null) {
            this.changesets = null;
            return;
        }
        this.changesets = new ArrayList<ChangesetSummary>(changesets);
    }

    public ListChangesetsResult withChangesets(ChangesetSummary ... changesets) {
        if (this.changesets == null) {
            this.setChangesets(new ArrayList<ChangesetSummary>(changesets.length));
        }
        for (ChangesetSummary ele : changesets) {
            this.changesets.add(ele);
        }
        return this;
    }

    public ListChangesetsResult withChangesets(Collection<ChangesetSummary> changesets) {
        this.setChangesets(changesets);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListChangesetsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChangesets() != null) {
            sb.append("Changesets: ").append(this.getChangesets()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangesetsResult)) {
            return false;
        }
        ListChangesetsResult other = (ListChangesetsResult)obj;
        if (other.getChangesets() == null ^ this.getChangesets() == null) {
            return false;
        }
        if (other.getChangesets() != null && !other.getChangesets().equals(this.getChangesets())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChangesets() == null ? 0 : this.getChangesets().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListChangesetsResult clone() {
        try {
            return (ListChangesetsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

