/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudwatchevents.model.ListTargetsByRuleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListTargetsByRuleRequestMarshaller
implements Marshaller<Request<ListTargetsByRuleRequest>, ListTargetsByRuleRequest> {
    public Request<ListTargetsByRuleRequest> marshall(ListTargetsByRuleRequest listTargetsByRuleRequest) {
        if (listTargetsByRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTargetsByRuleRequest, "AmazonCloudWatchEvents");
        request.addHeader("X-Amz-Target", "AWSEvents.ListTargetsByRule");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (listTargetsByRuleRequest.getRule() != null) {
                jsonGenerator.writeFieldName("Rule").writeValue(listTargetsByRuleRequest.getRule());
            }
            if (listTargetsByRuleRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listTargetsByRuleRequest.getNextToken());
            }
            if (listTargetsByRuleRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue((long)listTargetsByRuleRequest.getLimit().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

