/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudwatchevents.model.PutRuleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class PutRuleRequestMarshaller
implements Marshaller<Request<PutRuleRequest>, PutRuleRequest> {
    public Request<PutRuleRequest> marshall(PutRuleRequest putRuleRequest) {
        if (putRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putRuleRequest, "AmazonCloudWatchEvents");
        request.addHeader("X-Amz-Target", "AWSEvents.PutRule");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (putRuleRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)putRuleRequest.getName());
            }
            if (putRuleRequest.getScheduleExpression() != null) {
                jsonWriter.key("ScheduleExpression").value((Object)putRuleRequest.getScheduleExpression());
            }
            if (putRuleRequest.getEventPattern() != null) {
                jsonWriter.key("EventPattern").value((Object)putRuleRequest.getEventPattern());
            }
            if (putRuleRequest.getState() != null) {
                jsonWriter.key("State").value((Object)putRuleRequest.getState());
            }
            if (putRuleRequest.getDescription() != null) {
                jsonWriter.key("Description").value((Object)putRuleRequest.getDescription());
            }
            if (putRuleRequest.getRoleArn() != null) {
                jsonWriter.key("RoleArn").value((Object)putRuleRequest.getRoleArn());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

