/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eventbridge.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.eventbridge.model.Archive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListArchivesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Archive> archives;
    private String nextToken;

    public List<Archive> getArchives() {
        return this.archives;
    }

    public void setArchives(Collection<Archive> archives) {
        if (archives == null) {
            this.archives = null;
            return;
        }
        this.archives = new ArrayList<Archive>(archives);
    }

    public ListArchivesResult withArchives(Archive ... archives) {
        if (this.archives == null) {
            this.setArchives(new ArrayList<Archive>(archives.length));
        }
        for (Archive ele : archives) {
            this.archives.add(ele);
        }
        return this;
    }

    public ListArchivesResult withArchives(Collection<Archive> archives) {
        this.setArchives(archives);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListArchivesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArchives() != null) {
            sb.append("Archives: ").append(this.getArchives()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArchivesResult)) {
            return false;
        }
        ListArchivesResult other = (ListArchivesResult)obj;
        if (other.getArchives() == null ^ this.getArchives() == null) {
            return false;
        }
        if (other.getArchives() != null && !other.getArchives().equals(this.getArchives())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArchives() == null ? 0 : this.getArchives().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListArchivesResult clone() {
        try {
            return (ListArchivesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

