/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrserverless.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.emrserverless.model.ApplicationState;
import com.amazonaws.services.emrserverless.model.AutoStartConfig;
import com.amazonaws.services.emrserverless.model.AutoStopConfig;
import com.amazonaws.services.emrserverless.model.InitialCapacityConfig;
import com.amazonaws.services.emrserverless.model.MaximumAllowedResources;
import com.amazonaws.services.emrserverless.model.NetworkConfiguration;
import com.amazonaws.services.emrserverless.model.transform.ApplicationMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Application
implements Serializable,
Cloneable,
StructuredPojo {
    private String applicationId;
    private String name;
    private String arn;
    private String releaseLabel;
    private String type;
    private String state;
    private String stateDetails;
    private Map<String, InitialCapacityConfig> initialCapacity;
    private MaximumAllowedResources maximumCapacity;
    private Date createdAt;
    private Date updatedAt;
    private Map<String, String> tags;
    private AutoStartConfig autoStartConfiguration;
    private AutoStopConfig autoStopConfiguration;
    private NetworkConfiguration networkConfiguration;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Application withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Application withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Application withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setReleaseLabel(String releaseLabel) {
        this.releaseLabel = releaseLabel;
    }

    public String getReleaseLabel() {
        return this.releaseLabel;
    }

    public Application withReleaseLabel(String releaseLabel) {
        this.setReleaseLabel(releaseLabel);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Application withType(String type) {
        this.setType(type);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Application withState(String state) {
        this.setState(state);
        return this;
    }

    public Application withState(ApplicationState state) {
        this.state = state.toString();
        return this;
    }

    public void setStateDetails(String stateDetails) {
        this.stateDetails = stateDetails;
    }

    public String getStateDetails() {
        return this.stateDetails;
    }

    public Application withStateDetails(String stateDetails) {
        this.setStateDetails(stateDetails);
        return this;
    }

    public Map<String, InitialCapacityConfig> getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public Application withInitialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
        this.setInitialCapacity(initialCapacity);
        return this;
    }

    public Application addInitialCapacityEntry(String key, InitialCapacityConfig value) {
        if (null == this.initialCapacity) {
            this.initialCapacity = new HashMap<String, InitialCapacityConfig>();
        }
        if (this.initialCapacity.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.initialCapacity.put(key, value);
        return this;
    }

    public Application clearInitialCapacityEntries() {
        this.initialCapacity = null;
        return this;
    }

    public void setMaximumCapacity(MaximumAllowedResources maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
    }

    public MaximumAllowedResources getMaximumCapacity() {
        return this.maximumCapacity;
    }

    public Application withMaximumCapacity(MaximumAllowedResources maximumCapacity) {
        this.setMaximumCapacity(maximumCapacity);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Application withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Application withUpdatedAt(Date updatedAt) {
        this.setUpdatedAt(updatedAt);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Application withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Application addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Application clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setAutoStartConfiguration(AutoStartConfig autoStartConfiguration) {
        this.autoStartConfiguration = autoStartConfiguration;
    }

    public AutoStartConfig getAutoStartConfiguration() {
        return this.autoStartConfiguration;
    }

    public Application withAutoStartConfiguration(AutoStartConfig autoStartConfiguration) {
        this.setAutoStartConfiguration(autoStartConfiguration);
        return this;
    }

    public void setAutoStopConfiguration(AutoStopConfig autoStopConfiguration) {
        this.autoStopConfiguration = autoStopConfiguration;
    }

    public AutoStopConfig getAutoStopConfiguration() {
        return this.autoStopConfiguration;
    }

    public Application withAutoStopConfiguration(AutoStopConfig autoStopConfiguration) {
        this.setAutoStopConfiguration(autoStopConfiguration);
        return this;
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public Application withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.setNetworkConfiguration(networkConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getReleaseLabel() != null) {
            sb.append("ReleaseLabel: ").append(this.getReleaseLabel()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStateDetails() != null) {
            sb.append("StateDetails: ").append(this.getStateDetails()).append(",");
        }
        if (this.getInitialCapacity() != null) {
            sb.append("InitialCapacity: ").append(this.getInitialCapacity()).append(",");
        }
        if (this.getMaximumCapacity() != null) {
            sb.append("MaximumCapacity: ").append(this.getMaximumCapacity()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getUpdatedAt() != null) {
            sb.append("UpdatedAt: ").append(this.getUpdatedAt()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAutoStartConfiguration() != null) {
            sb.append("AutoStartConfiguration: ").append(this.getAutoStartConfiguration()).append(",");
        }
        if (this.getAutoStopConfiguration() != null) {
            sb.append("AutoStopConfiguration: ").append(this.getAutoStopConfiguration()).append(",");
        }
        if (this.getNetworkConfiguration() != null) {
            sb.append("NetworkConfiguration: ").append(this.getNetworkConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getReleaseLabel() == null ^ this.getReleaseLabel() == null) {
            return false;
        }
        if (other.getReleaseLabel() != null && !other.getReleaseLabel().equals(this.getReleaseLabel())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStateDetails() == null ^ this.getStateDetails() == null) {
            return false;
        }
        if (other.getStateDetails() != null && !other.getStateDetails().equals(this.getStateDetails())) {
            return false;
        }
        if (other.getInitialCapacity() == null ^ this.getInitialCapacity() == null) {
            return false;
        }
        if (other.getInitialCapacity() != null && !other.getInitialCapacity().equals(this.getInitialCapacity())) {
            return false;
        }
        if (other.getMaximumCapacity() == null ^ this.getMaximumCapacity() == null) {
            return false;
        }
        if (other.getMaximumCapacity() != null && !other.getMaximumCapacity().equals(this.getMaximumCapacity())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null) {
            return false;
        }
        if (other.getUpdatedAt() != null && !other.getUpdatedAt().equals(this.getUpdatedAt())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAutoStartConfiguration() == null ^ this.getAutoStartConfiguration() == null) {
            return false;
        }
        if (other.getAutoStartConfiguration() != null && !other.getAutoStartConfiguration().equals(this.getAutoStartConfiguration())) {
            return false;
        }
        if (other.getAutoStopConfiguration() == null ^ this.getAutoStopConfiguration() == null) {
            return false;
        }
        if (other.getAutoStopConfiguration() != null && !other.getAutoStopConfiguration().equals(this.getAutoStopConfiguration())) {
            return false;
        }
        if (other.getNetworkConfiguration() == null ^ this.getNetworkConfiguration() == null) {
            return false;
        }
        return other.getNetworkConfiguration() == null || other.getNetworkConfiguration().equals(this.getNetworkConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseLabel() == null ? 0 : this.getReleaseLabel().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStateDetails() == null ? 0 : this.getStateDetails().hashCode());
        hashCode = 31 * hashCode + (this.getInitialCapacity() == null ? 0 : this.getInitialCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumCapacity() == null ? 0 : this.getMaximumCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedAt() == null ? 0 : this.getUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAutoStartConfiguration() == null ? 0 : this.getAutoStartConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAutoStopConfiguration() == null ? 0 : this.getAutoStopConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkConfiguration() == null ? 0 : this.getNetworkConfiguration().hashCode());
        return hashCode;
    }

    public Application clone() {
        try {
            return (Application)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

