/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.ClusterSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListClustersResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<ClusterSummary> clusters;
    private String marker;

    public List<ClusterSummary> getClusters() {
        if (this.clusters == null) {
            this.clusters = new ListWithAutoConstructFlag();
            this.clusters.setAutoConstruct(true);
        }
        return this.clusters;
    }

    public void setClusters(Collection<ClusterSummary> clusters) {
        if (clusters == null) {
            this.clusters = null;
            return;
        }
        ListWithAutoConstructFlag clustersCopy = new ListWithAutoConstructFlag(clusters.size());
        clustersCopy.addAll(clusters);
        this.clusters = clustersCopy;
    }

    public ListClustersResult withClusters(ClusterSummary ... clusters) {
        if (this.getClusters() == null) {
            this.setClusters(new ArrayList<ClusterSummary>(clusters.length));
        }
        for (ClusterSummary value : clusters) {
            this.getClusters().add(value);
        }
        return this;
    }

    public ListClustersResult withClusters(Collection<ClusterSummary> clusters) {
        if (clusters == null) {
            this.clusters = null;
        } else {
            ListWithAutoConstructFlag clustersCopy = new ListWithAutoConstructFlag(clusters.size());
            clustersCopy.addAll(clusters);
            this.clusters = clustersCopy;
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListClustersResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusters() != null) {
            sb.append("Clusters: " + this.getClusters() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusters() == null ? 0 : this.getClusters().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResult)) {
            return false;
        }
        ListClustersResult other = (ListClustersResult)obj;
        if (other.getClusters() == null ^ this.getClusters() == null) {
            return false;
        }
        if (other.getClusters() != null && !other.getClusters().equals(this.getClusters())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public ListClustersResult clone() {
        try {
            return (ListClustersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

