/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroup;
import java.util.List;

@SdkInternalApi
public class InstanceGroupMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> MARKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Market").build();
    private static final MarshallingInfo<String> INSTANCEGROUPTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceGroupType").build();
    private static final MarshallingInfo<String> BIDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BidPrice").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<Integer> REQUESTEDINSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedInstanceCount").build();
    private static final MarshallingInfo<Integer> RUNNINGINSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RunningInstanceCount").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<List> CONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configurations").build();
    private static final MarshallingInfo<Long> CONFIGURATIONSVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationsVersion").build();
    private static final MarshallingInfo<List> LASTSUCCESSFULLYAPPLIEDCONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSuccessfullyAppliedConfigurations").build();
    private static final MarshallingInfo<Long> LASTSUCCESSFULLYAPPLIEDCONFIGURATIONSVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSuccessfullyAppliedConfigurationsVersion").build();
    private static final MarshallingInfo<List> EBSBLOCKDEVICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsBlockDevices").build();
    private static final MarshallingInfo<Boolean> EBSOPTIMIZED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimized").build();
    private static final MarshallingInfo<StructuredPojo> SHRINKPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShrinkPolicy").build();
    private static final MarshallingInfo<StructuredPojo> AUTOSCALINGPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingPolicy").build();
    private static final MarshallingInfo<String> CUSTOMAMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomAmiId").build();
    private static final InstanceGroupMarshaller instance = new InstanceGroupMarshaller();

    public static InstanceGroupMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstanceGroup instanceGroup, ProtocolMarshaller protocolMarshaller) {
        if (instanceGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceGroup.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getMarket(), MARKET_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getInstanceGroupType(), INSTANCEGROUPTYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getBidPrice(), BIDPRICE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getInstanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getRequestedInstanceCount(), REQUESTEDINSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getRunningInstanceCount(), RUNNINGINSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(instanceGroup.getConfigurations(), CONFIGURATIONS_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getConfigurationsVersion(), CONFIGURATIONSVERSION_BINDING);
            protocolMarshaller.marshall(instanceGroup.getLastSuccessfullyAppliedConfigurations(), LASTSUCCESSFULLYAPPLIEDCONFIGURATIONS_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getLastSuccessfullyAppliedConfigurationsVersion(), LASTSUCCESSFULLYAPPLIEDCONFIGURATIONSVERSION_BINDING);
            protocolMarshaller.marshall(instanceGroup.getEbsBlockDevices(), EBSBLOCKDEVICES_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getEbsOptimized(), EBSOPTIMIZED_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getShrinkPolicy(), SHRINKPOLICY_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getAutoScalingPolicy(), AUTOSCALINGPOLICY_BINDING);
            protocolMarshaller.marshall((Object)instanceGroup.getCustomAmiId(), CUSTOMAMIID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

