/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.AutoScalingPolicyDescription;
import com.amazonaws.services.elasticmapreduce.model.ScalingRule;
import com.amazonaws.services.elasticmapreduce.model.transform.AutoScalingPolicyStatusJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ScalingConstraintsJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ScalingRuleJsonMarshaller;

public class AutoScalingPolicyDescriptionJsonMarshaller {
    private static AutoScalingPolicyDescriptionJsonMarshaller instance;

    public void marshall(AutoScalingPolicyDescription autoScalingPolicyDescription, StructuredJsonGenerator jsonGenerator) {
        if (autoScalingPolicyDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList rulesList;
            jsonGenerator.writeStartObject();
            if (autoScalingPolicyDescription.getStatus() != null) {
                jsonGenerator.writeFieldName("Status");
                AutoScalingPolicyStatusJsonMarshaller.getInstance().marshall(autoScalingPolicyDescription.getStatus(), jsonGenerator);
            }
            if (autoScalingPolicyDescription.getConstraints() != null) {
                jsonGenerator.writeFieldName("Constraints");
                ScalingConstraintsJsonMarshaller.getInstance().marshall(autoScalingPolicyDescription.getConstraints(), jsonGenerator);
            }
            if (!(rulesList = (SdkInternalList)autoScalingPolicyDescription.getRules()).isEmpty() || !rulesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Rules");
                jsonGenerator.writeStartArray();
                for (ScalingRule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    ScalingRuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AutoScalingPolicyDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AutoScalingPolicyDescriptionJsonMarshaller();
        }
        return instance;
    }
}

