/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.ShrinkPolicy;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceGroupModifyConfigMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InstanceGroupModifyConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String instanceGroupId;
    private Integer instanceCount;
    private SdkInternalList<String> eC2InstanceIdsToTerminate;
    private ShrinkPolicy shrinkPolicy;
    private SdkInternalList<Configuration> configurations;

    public InstanceGroupModifyConfig() {
    }

    public InstanceGroupModifyConfig(String instanceGroupId, Integer instanceCount) {
        this.setInstanceGroupId(instanceGroupId);
        this.setInstanceCount(instanceCount);
    }

    public void setInstanceGroupId(String instanceGroupId) {
        this.instanceGroupId = instanceGroupId;
    }

    public String getInstanceGroupId() {
        return this.instanceGroupId;
    }

    public InstanceGroupModifyConfig withInstanceGroupId(String instanceGroupId) {
        this.setInstanceGroupId(instanceGroupId);
        return this;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public InstanceGroupModifyConfig withInstanceCount(Integer instanceCount) {
        this.setInstanceCount(instanceCount);
        return this;
    }

    public List<String> getEC2InstanceIdsToTerminate() {
        if (this.eC2InstanceIdsToTerminate == null) {
            this.eC2InstanceIdsToTerminate = new SdkInternalList();
        }
        return this.eC2InstanceIdsToTerminate;
    }

    public void setEC2InstanceIdsToTerminate(Collection<String> eC2InstanceIdsToTerminate) {
        if (eC2InstanceIdsToTerminate == null) {
            this.eC2InstanceIdsToTerminate = null;
            return;
        }
        this.eC2InstanceIdsToTerminate = new SdkInternalList(eC2InstanceIdsToTerminate);
    }

    public InstanceGroupModifyConfig withEC2InstanceIdsToTerminate(String ... eC2InstanceIdsToTerminate) {
        if (this.eC2InstanceIdsToTerminate == null) {
            this.setEC2InstanceIdsToTerminate((Collection<String>)new SdkInternalList(eC2InstanceIdsToTerminate.length));
        }
        for (String ele : eC2InstanceIdsToTerminate) {
            this.eC2InstanceIdsToTerminate.add((Object)ele);
        }
        return this;
    }

    public InstanceGroupModifyConfig withEC2InstanceIdsToTerminate(Collection<String> eC2InstanceIdsToTerminate) {
        this.setEC2InstanceIdsToTerminate(eC2InstanceIdsToTerminate);
        return this;
    }

    public void setShrinkPolicy(ShrinkPolicy shrinkPolicy) {
        this.shrinkPolicy = shrinkPolicy;
    }

    public ShrinkPolicy getShrinkPolicy() {
        return this.shrinkPolicy;
    }

    public InstanceGroupModifyConfig withShrinkPolicy(ShrinkPolicy shrinkPolicy) {
        this.setShrinkPolicy(shrinkPolicy);
        return this;
    }

    public List<Configuration> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new SdkInternalList();
        }
        return this.configurations;
    }

    public void setConfigurations(Collection<Configuration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        this.configurations = new SdkInternalList(configurations);
    }

    public InstanceGroupModifyConfig withConfigurations(Configuration ... configurations) {
        if (this.configurations == null) {
            this.setConfigurations((Collection<Configuration>)new SdkInternalList(configurations.length));
        }
        for (Configuration ele : configurations) {
            this.configurations.add((Object)ele);
        }
        return this;
    }

    public InstanceGroupModifyConfig withConfigurations(Collection<Configuration> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceGroupId() != null) {
            sb.append("InstanceGroupId: ").append(this.getInstanceGroupId()).append(",");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: ").append(this.getInstanceCount()).append(",");
        }
        if (this.getEC2InstanceIdsToTerminate() != null) {
            sb.append("EC2InstanceIdsToTerminate: ").append(this.getEC2InstanceIdsToTerminate()).append(",");
        }
        if (this.getShrinkPolicy() != null) {
            sb.append("ShrinkPolicy: ").append(this.getShrinkPolicy()).append(",");
        }
        if (this.getConfigurations() != null) {
            sb.append("Configurations: ").append(this.getConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupModifyConfig)) {
            return false;
        }
        InstanceGroupModifyConfig other = (InstanceGroupModifyConfig)obj;
        if (other.getInstanceGroupId() == null ^ this.getInstanceGroupId() == null) {
            return false;
        }
        if (other.getInstanceGroupId() != null && !other.getInstanceGroupId().equals(this.getInstanceGroupId())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getEC2InstanceIdsToTerminate() == null ^ this.getEC2InstanceIdsToTerminate() == null) {
            return false;
        }
        if (other.getEC2InstanceIdsToTerminate() != null && !other.getEC2InstanceIdsToTerminate().equals(this.getEC2InstanceIdsToTerminate())) {
            return false;
        }
        if (other.getShrinkPolicy() == null ^ this.getShrinkPolicy() == null) {
            return false;
        }
        if (other.getShrinkPolicy() != null && !other.getShrinkPolicy().equals(this.getShrinkPolicy())) {
            return false;
        }
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        return other.getConfigurations() == null || other.getConfigurations().equals(this.getConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceGroupId() == null ? 0 : this.getInstanceGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getEC2InstanceIdsToTerminate() == null ? 0 : this.getEC2InstanceIdsToTerminate().hashCode());
        hashCode = 31 * hashCode + (this.getShrinkPolicy() == null ? 0 : this.getShrinkPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        return hashCode;
    }

    public InstanceGroupModifyConfig clone() {
        try {
            return (InstanceGroupModifyConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceGroupModifyConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

