/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyInstanceGroupsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterId;
    private SdkInternalList<InstanceGroupModifyConfig> instanceGroups;

    public ModifyInstanceGroupsRequest() {
    }

    public ModifyInstanceGroupsRequest(List<InstanceGroupModifyConfig> instanceGroups) {
        this.setInstanceGroups(instanceGroups);
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public ModifyInstanceGroupsRequest withClusterId(String clusterId) {
        this.setClusterId(clusterId);
        return this;
    }

    public List<InstanceGroupModifyConfig> getInstanceGroups() {
        if (this.instanceGroups == null) {
            this.instanceGroups = new SdkInternalList();
        }
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroupModifyConfig> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
            return;
        }
        this.instanceGroups = new SdkInternalList(instanceGroups);
    }

    public ModifyInstanceGroupsRequest withInstanceGroups(InstanceGroupModifyConfig ... instanceGroups) {
        if (this.instanceGroups == null) {
            this.setInstanceGroups((Collection<InstanceGroupModifyConfig>)new SdkInternalList(instanceGroups.length));
        }
        for (InstanceGroupModifyConfig ele : instanceGroups) {
            this.instanceGroups.add((Object)ele);
        }
        return this;
    }

    public ModifyInstanceGroupsRequest withInstanceGroups(Collection<InstanceGroupModifyConfig> instanceGroups) {
        this.setInstanceGroups(instanceGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterId() != null) {
            sb.append("ClusterId: " + this.getClusterId() + ",");
        }
        if (this.getInstanceGroups() != null) {
            sb.append("InstanceGroups: " + this.getInstanceGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceGroupsRequest)) {
            return false;
        }
        ModifyInstanceGroupsRequest other = (ModifyInstanceGroupsRequest)obj;
        if (other.getClusterId() == null ^ this.getClusterId() == null) {
            return false;
        }
        if (other.getClusterId() != null && !other.getClusterId().equals(this.getClusterId())) {
            return false;
        }
        if (other.getInstanceGroups() == null ^ this.getInstanceGroups() == null) {
            return false;
        }
        return other.getInstanceGroups() == null || other.getInstanceGroups().equals(this.getInstanceGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterId() == null ? 0 : this.getClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceGroups() == null ? 0 : this.getInstanceGroups().hashCode());
        return hashCode;
    }

    public ModifyInstanceGroupsRequest clone() {
        return (ModifyInstanceGroupsRequest)super.clone();
    }
}

