/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.EbsBlockDevice;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroup;
import com.amazonaws.services.elasticmapreduce.model.transform.ConfigurationJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.EbsBlockDeviceJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceGroupStatusJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ShrinkPolicyJsonMarshaller;

public class InstanceGroupJsonMarshaller {
    private static InstanceGroupJsonMarshaller instance;

    public void marshall(InstanceGroup instanceGroup, StructuredJsonGenerator jsonGenerator) {
        if (instanceGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList ebsBlockDevicesList;
            SdkInternalList configurationsList;
            jsonGenerator.writeStartObject();
            if (instanceGroup.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(instanceGroup.getId());
            }
            if (instanceGroup.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(instanceGroup.getName());
            }
            if (instanceGroup.getMarket() != null) {
                jsonGenerator.writeFieldName("Market").writeValue(instanceGroup.getMarket());
            }
            if (instanceGroup.getInstanceGroupType() != null) {
                jsonGenerator.writeFieldName("InstanceGroupType").writeValue(instanceGroup.getInstanceGroupType());
            }
            if (instanceGroup.getBidPrice() != null) {
                jsonGenerator.writeFieldName("BidPrice").writeValue(instanceGroup.getBidPrice());
            }
            if (instanceGroup.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(instanceGroup.getInstanceType());
            }
            if (instanceGroup.getRequestedInstanceCount() != null) {
                jsonGenerator.writeFieldName("RequestedInstanceCount").writeValue(instanceGroup.getRequestedInstanceCount().intValue());
            }
            if (instanceGroup.getRunningInstanceCount() != null) {
                jsonGenerator.writeFieldName("RunningInstanceCount").writeValue(instanceGroup.getRunningInstanceCount().intValue());
            }
            if (instanceGroup.getStatus() != null) {
                jsonGenerator.writeFieldName("Status");
                InstanceGroupStatusJsonMarshaller.getInstance().marshall(instanceGroup.getStatus(), jsonGenerator);
            }
            if (!(configurationsList = (SdkInternalList)instanceGroup.getConfigurations()).isEmpty() || !configurationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Configurations");
                jsonGenerator.writeStartArray();
                for (Configuration configurationsListValue : configurationsList) {
                    if (configurationsListValue == null) continue;
                    ConfigurationJsonMarshaller.getInstance().marshall(configurationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(ebsBlockDevicesList = (SdkInternalList)instanceGroup.getEbsBlockDevices()).isEmpty() || !ebsBlockDevicesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("EbsBlockDevices");
                jsonGenerator.writeStartArray();
                for (EbsBlockDevice ebsBlockDevicesListValue : ebsBlockDevicesList) {
                    if (ebsBlockDevicesListValue == null) continue;
                    EbsBlockDeviceJsonMarshaller.getInstance().marshall(ebsBlockDevicesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (instanceGroup.getEbsOptimized() != null) {
                jsonGenerator.writeFieldName("EbsOptimized").writeValue(instanceGroup.getEbsOptimized().booleanValue());
            }
            if (instanceGroup.getShrinkPolicy() != null) {
                jsonGenerator.writeFieldName("ShrinkPolicy");
                ShrinkPolicyJsonMarshaller.getInstance().marshall(instanceGroup.getShrinkPolicy(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceGroupJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceGroupJsonMarshaller();
        }
        return instance;
    }
}

