/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeJobFlowsRequestMarshaller
implements Marshaller<Request<DescribeJobFlowsRequest>, DescribeJobFlowsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeJobFlowsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeJobFlowsRequest> marshall(DescribeJobFlowsRequest describeJobFlowsRequest) {
        if (describeJobFlowsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeJobFlowsRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.DescribeJobFlows");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList jobFlowStatesList;
            SdkInternalList jobFlowIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeJobFlowsRequest.getCreatedAfter() != null) {
                jsonGenerator.writeFieldName("CreatedAfter").writeValue(describeJobFlowsRequest.getCreatedAfter());
            }
            if (describeJobFlowsRequest.getCreatedBefore() != null) {
                jsonGenerator.writeFieldName("CreatedBefore").writeValue(describeJobFlowsRequest.getCreatedBefore());
            }
            if (!(jobFlowIdsList = (SdkInternalList)describeJobFlowsRequest.getJobFlowIds()).isEmpty() || !jobFlowIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("JobFlowIds");
                jsonGenerator.writeStartArray();
                for (String jobFlowIdsListValue : jobFlowIdsList) {
                    if (jobFlowIdsListValue == null) continue;
                    jsonGenerator.writeValue(jobFlowIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(jobFlowStatesList = (SdkInternalList)describeJobFlowsRequest.getJobFlowStates()).isEmpty() || !jobFlowStatesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("JobFlowStates");
                jsonGenerator.writeStartArray();
                for (String jobFlowStatesListValue : jobFlowStatesList) {
                    if (jobFlowStatesListValue == null) continue;
                    jsonGenerator.writeValue(jobFlowStatesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

