/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticmapreduce.model.ScalingConstraints;
import com.amazonaws.services.elasticmapreduce.model.ScalingRule;
import com.amazonaws.services.elasticmapreduce.model.transform.AutoScalingPolicyMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AutoScalingPolicy
implements Serializable,
Cloneable,
StructuredPojo {
    private ScalingConstraints constraints;
    private SdkInternalList<ScalingRule> rules;

    public void setConstraints(ScalingConstraints constraints) {
        this.constraints = constraints;
    }

    public ScalingConstraints getConstraints() {
        return this.constraints;
    }

    public AutoScalingPolicy withConstraints(ScalingConstraints constraints) {
        this.setConstraints(constraints);
        return this;
    }

    public List<ScalingRule> getRules() {
        if (this.rules == null) {
            this.rules = new SdkInternalList();
        }
        return this.rules;
    }

    public void setRules(Collection<ScalingRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new SdkInternalList(rules);
    }

    public AutoScalingPolicy withRules(ScalingRule ... rules) {
        if (this.rules == null) {
            this.setRules((Collection<ScalingRule>)new SdkInternalList(rules.length));
        }
        for (ScalingRule ele : rules) {
            this.rules.add((Object)ele);
        }
        return this;
    }

    public AutoScalingPolicy withRules(Collection<ScalingRule> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConstraints() != null) {
            sb.append("Constraints: ").append(this.getConstraints()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicy)) {
            return false;
        }
        AutoScalingPolicy other = (AutoScalingPolicy)obj;
        if (other.getConstraints() == null ^ this.getConstraints() == null) {
            return false;
        }
        if (other.getConstraints() != null && !other.getConstraints().equals(this.getConstraints())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConstraints() == null ? 0 : this.getConstraints().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public AutoScalingPolicy clone() {
        try {
            return (AutoScalingPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

