/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.ListClustersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListClustersRequestMarshaller
implements Marshaller<Request<ListClustersRequest>, ListClustersRequest> {
    public Request<ListClustersRequest> marshall(ListClustersRequest listClustersRequest) {
        if (listClustersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listClustersRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.ListClusters");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList clusterStatesList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (listClustersRequest.getCreatedAfter() != null) {
                jsonGenerator.writeFieldName("CreatedAfter").writeValue(listClustersRequest.getCreatedAfter());
            }
            if (listClustersRequest.getCreatedBefore() != null) {
                jsonGenerator.writeFieldName("CreatedBefore").writeValue(listClustersRequest.getCreatedBefore());
            }
            if (!(clusterStatesList = (SdkInternalList)listClustersRequest.getClusterStates()).isEmpty() || !clusterStatesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ClusterStates");
                jsonGenerator.writeStartArray();
                for (String clusterStatesListValue : clusterStatesList) {
                    if (clusterStatesListValue == null) continue;
                    jsonGenerator.writeValue(clusterStatesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listClustersRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listClustersRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

