/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.EbsBlockDevice;
import com.amazonaws.services.elasticmapreduce.model.transform.VolumeSpecificationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class EbsBlockDeviceJsonMarshaller {
    private static EbsBlockDeviceJsonMarshaller instance;

    public void marshall(EbsBlockDevice ebsBlockDevice, JSONWriter jsonWriter) {
        if (ebsBlockDevice == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (ebsBlockDevice.getVolumeSpecification() != null) {
                jsonWriter.key("VolumeSpecification");
                VolumeSpecificationJsonMarshaller.getInstance().marshall(ebsBlockDevice.getVolumeSpecification(), jsonWriter);
            }
            if (ebsBlockDevice.getDevice() != null) {
                jsonWriter.key("Device").value((Object)ebsBlockDevice.getDevice());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EbsBlockDeviceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EbsBlockDeviceJsonMarshaller();
        }
        return instance;
    }
}

