/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class DescribeJobFlowsRequestMarshaller
implements Marshaller<Request<DescribeJobFlowsRequest>, DescribeJobFlowsRequest> {
    public Request<DescribeJobFlowsRequest> marshall(DescribeJobFlowsRequest describeJobFlowsRequest) {
        if (describeJobFlowsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeJobFlowsRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.DescribeJobFlows");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList jobFlowStatesList;
            SdkInternalList jobFlowIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (describeJobFlowsRequest.getCreatedAfter() != null) {
                jsonWriter.key("CreatedAfter").value(describeJobFlowsRequest.getCreatedAfter());
            }
            if (describeJobFlowsRequest.getCreatedBefore() != null) {
                jsonWriter.key("CreatedBefore").value(describeJobFlowsRequest.getCreatedBefore());
            }
            if (!(jobFlowIdsList = (SdkInternalList)describeJobFlowsRequest.getJobFlowIds()).isEmpty() || !jobFlowIdsList.isAutoConstruct()) {
                jsonWriter.key("JobFlowIds");
                jsonWriter.array();
                for (String jobFlowIdsListValue : jobFlowIdsList) {
                    if (jobFlowIdsListValue == null) continue;
                    jsonWriter.value((Object)jobFlowIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (!(jobFlowStatesList = (SdkInternalList)describeJobFlowsRequest.getJobFlowStates()).isEmpty() || !jobFlowStatesList.isAutoConstruct()) {
                jsonWriter.key("JobFlowStates");
                jsonWriter.array();
                for (String jobFlowStatesListValue : jobFlowStatesList) {
                    if (jobFlowStatesListValue == null) continue;
                    jsonWriter.value((Object)jobFlowStatesListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

