/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.elasticmapreduce.model.Application;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class ApplicationJsonMarshaller {
    private static ApplicationJsonMarshaller instance;

    public void marshall(Application application, JSONWriter jsonWriter) {
        if (application == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap additionalInfoMap;
            SdkInternalList argsList;
            jsonWriter.object();
            if (application.getName() != null) {
                jsonWriter.key("Name").value((Object)application.getName());
            }
            if (application.getVersion() != null) {
                jsonWriter.key("Version").value((Object)application.getVersion());
            }
            if (!(argsList = (SdkInternalList)application.getArgs()).isEmpty() || !argsList.isAutoConstruct()) {
                jsonWriter.key("Args");
                jsonWriter.array();
                for (String argsListValue : argsList) {
                    if (argsListValue == null) continue;
                    jsonWriter.value((Object)argsListValue);
                }
                jsonWriter.endArray();
            }
            if (!(additionalInfoMap = (SdkInternalMap)application.getAdditionalInfo()).isEmpty() || !additionalInfoMap.isAutoConstruct()) {
                jsonWriter.key("AdditionalInfo");
                jsonWriter.object();
                for (Map.Entry additionalInfoMapValue : additionalInfoMap.entrySet()) {
                    if (additionalInfoMapValue.getValue() == null) continue;
                    jsonWriter.key((String)additionalInfoMapValue.getKey());
                    jsonWriter.value(additionalInfoMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ApplicationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ApplicationJsonMarshaller();
        }
        return instance;
    }
}

