/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduce;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsResult;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsResult;
import com.amazonaws.services.elasticmapreduce.model.AddTagsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddTagsResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepResult;
import com.amazonaws.services.elasticmapreduce.model.InternalServerErrorException;
import com.amazonaws.services.elasticmapreduce.model.InternalServerException;
import com.amazonaws.services.elasticmapreduce.model.InvalidRequestException;
import com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsResult;
import com.amazonaws.services.elasticmapreduce.model.ListClustersRequest;
import com.amazonaws.services.elasticmapreduce.model.ListClustersResult;
import com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsResult;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesResult;
import com.amazonaws.services.elasticmapreduce.model.ListStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListStepsResult;
import com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest;
import com.amazonaws.services.elasticmapreduce.model.RemoveTagsResult;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowResult;
import com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest;
import com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest;
import com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.transform.AddInstanceGroupsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.AddInstanceGroupsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.AddJobFlowStepsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.AddJobFlowStepsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.AddTagsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.AddTagsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeClusterRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeClusterResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeJobFlowsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeJobFlowsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeStepRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeStepResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListBootstrapActionsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListBootstrapActionsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListClustersRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListClustersResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListInstanceGroupsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListInstanceGroupsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListInstancesRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListInstancesResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListStepsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListStepsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ModifyInstanceGroupsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.RemoveTagsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.RemoveTagsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.RunJobFlowRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.RunJobFlowResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.SetTerminationProtectionRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.SetVisibleToAllUsersRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.TerminateJobFlowsRequestMarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonElasticMapReduceClient
extends AmazonWebServiceClient
implements AmazonElasticMapReduce {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonElasticMapReduce.class);
    private static final String DEFAULT_SIGNING_NAME = "elasticmapreduce";
    private static final String DEFAULT_ENDPOINT_PREFIX = "elasticmapreduce";
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AmazonElasticMapReduceClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonElasticMapReduceClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonElasticMapReduceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonElasticMapReduceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonElasticMapReduceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonElasticMapReduceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonElasticMapReduceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InternalServerException.class, "InternalServerException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InternalServerErrorException.class, "InternalServerError"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRequestException.class, "InvalidRequestException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setEndpoint("https://elasticmapreduce.amazonaws.com");
        this.setServiceNameIntern("elasticmapreduce");
        this.setEndpointPrefix("elasticmapreduce");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elasticmapreduce/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/elasticmapreduce/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddInstanceGroupsResult addInstanceGroups(AddInstanceGroupsRequest addInstanceGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addInstanceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddInstanceGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddInstanceGroupsRequestMarshaller().marshall(addInstanceGroupsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new AddInstanceGroupsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            AddInstanceGroupsResult addInstanceGroupsResult = (AddInstanceGroupsResult)response.getAwsResponse();
            return addInstanceGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddJobFlowStepsResult addJobFlowSteps(AddJobFlowStepsRequest addJobFlowStepsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addJobFlowStepsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddJobFlowStepsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddJobFlowStepsRequestMarshaller().marshall(addJobFlowStepsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new AddJobFlowStepsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            AddJobFlowStepsResult addJobFlowStepsResult = (AddJobFlowStepsResult)response.getAwsResponse();
            return addJobFlowStepsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsResult addTags(AddTagsRequest addTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddTagsRequestMarshaller().marshall(addTagsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new AddTagsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            AddTagsResult addTagsResult = (AddTagsResult)response.getAwsResponse();
            return addTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClusterResult describeCluster(DescribeClusterRequest describeClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeClusterRequestMarshaller().marshall(describeClusterRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeClusterResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeClusterResult describeClusterResult = (DescribeClusterResult)response.getAwsResponse();
            return describeClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public DescribeJobFlowsResult describeJobFlows(DescribeJobFlowsRequest describeJobFlowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobFlowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobFlowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobFlowsRequestMarshaller().marshall(describeJobFlowsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeJobFlowsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeJobFlowsResult describeJobFlowsResult = (DescribeJobFlowsResult)response.getAwsResponse();
            return describeJobFlowsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    @Deprecated
    public DescribeJobFlowsResult describeJobFlows() {
        return this.describeJobFlows(new DescribeJobFlowsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStepResult describeStep(DescribeStepRequest describeStepRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeStepRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeStepRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeStepRequestMarshaller().marshall(describeStepRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeStepResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeStepResult describeStepResult = (DescribeStepResult)response.getAwsResponse();
            return describeStepResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBootstrapActionsResult listBootstrapActions(ListBootstrapActionsRequest listBootstrapActionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBootstrapActionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBootstrapActionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBootstrapActionsRequestMarshaller().marshall(listBootstrapActionsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListBootstrapActionsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListBootstrapActionsResult listBootstrapActionsResult = (ListBootstrapActionsResult)response.getAwsResponse();
            return listBootstrapActionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClustersResult listClusters(ListClustersRequest listClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListClustersRequestMarshaller().marshall(listClustersRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListClustersResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListClustersResult listClustersResult = (ListClustersResult)response.getAwsResponse();
            return listClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListClustersResult listClusters() {
        return this.listClusters(new ListClustersRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInstanceGroupsResult listInstanceGroups(ListInstanceGroupsRequest listInstanceGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInstanceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInstanceGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInstanceGroupsRequestMarshaller().marshall(listInstanceGroupsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListInstanceGroupsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListInstanceGroupsResult listInstanceGroupsResult = (ListInstanceGroupsResult)response.getAwsResponse();
            return listInstanceGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInstancesResult listInstances(ListInstancesRequest listInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInstancesRequestMarshaller().marshall(listInstancesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListInstancesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListInstancesResult listInstancesResult = (ListInstancesResult)response.getAwsResponse();
            return listInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStepsResult listSteps(ListStepsRequest listStepsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStepsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStepsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStepsRequestMarshaller().marshall(listStepsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListStepsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListStepsResult listStepsResult = (ListStepsResult)response.getAwsResponse();
            return listStepsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyInstanceGroups(ModifyInstanceGroupsRequest modifyInstanceGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyInstanceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyInstanceGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyInstanceGroupsRequestMarshaller().marshall(modifyInstanceGroupsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void modifyInstanceGroups() {
        this.modifyInstanceGroups(new ModifyInstanceGroupsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsResult removeTags(RemoveTagsRequest removeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTagsRequestMarshaller().marshall(removeTagsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new RemoveTagsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RemoveTagsResult removeTagsResult = (RemoveTagsResult)response.getAwsResponse();
            return removeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunJobFlowResult runJobFlow(RunJobFlowRequest runJobFlowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(runJobFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RunJobFlowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RunJobFlowRequestMarshaller().marshall(runJobFlowRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new RunJobFlowResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RunJobFlowResult runJobFlowResult = (RunJobFlowResult)response.getAwsResponse();
            return runJobFlowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTerminationProtection(SetTerminationProtectionRequest setTerminationProtectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setTerminationProtectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetTerminationProtectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetTerminationProtectionRequestMarshaller().marshall(setTerminationProtectionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisibleToAllUsers(SetVisibleToAllUsersRequest setVisibleToAllUsersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setVisibleToAllUsersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetVisibleToAllUsersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetVisibleToAllUsersRequestMarshaller().marshall(setVisibleToAllUsersRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateJobFlows(TerminateJobFlowsRequest terminateJobFlowsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(terminateJobFlowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TerminateJobFlowsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TerminateJobFlowsRequestMarshaller().marshall(terminateJobFlowsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

