/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.Application;
import com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig;
import com.amazonaws.services.elasticmapreduce.model.Tag;
import com.amazonaws.services.elasticmapreduce.model.transform.ApplicationJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.BootstrapActionConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ConfigurationJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.JobFlowInstancesConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.StepConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.SupportedProductConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class RunJobFlowRequestMarshaller
implements Marshaller<Request<RunJobFlowRequest>, RunJobFlowRequest> {
    public Request<RunJobFlowRequest> marshall(RunJobFlowRequest runJobFlowRequest) {
        if (runJobFlowRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)runJobFlowRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.RunJobFlow");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagsList;
            SdkInternalList configurationsList;
            SdkInternalList applicationsList;
            SdkInternalList newSupportedProductsList;
            SdkInternalList supportedProductsList;
            SdkInternalList bootstrapActionsList;
            SdkInternalList stepsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (runJobFlowRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)runJobFlowRequest.getName());
            }
            if (runJobFlowRequest.getLogUri() != null) {
                jsonWriter.key("LogUri").value((Object)runJobFlowRequest.getLogUri());
            }
            if (runJobFlowRequest.getAdditionalInfo() != null) {
                jsonWriter.key("AdditionalInfo").value((Object)runJobFlowRequest.getAdditionalInfo());
            }
            if (runJobFlowRequest.getAmiVersion() != null) {
                jsonWriter.key("AmiVersion").value((Object)runJobFlowRequest.getAmiVersion());
            }
            if (runJobFlowRequest.getReleaseLabel() != null) {
                jsonWriter.key("ReleaseLabel").value((Object)runJobFlowRequest.getReleaseLabel());
            }
            if (runJobFlowRequest.getInstances() != null) {
                jsonWriter.key("Instances");
                JobFlowInstancesConfigJsonMarshaller.getInstance().marshall(runJobFlowRequest.getInstances(), jsonWriter);
            }
            if (!(stepsList = (SdkInternalList)runJobFlowRequest.getSteps()).isEmpty() || !stepsList.isAutoConstruct()) {
                jsonWriter.key("Steps");
                jsonWriter.array();
                for (StepConfig stepsListValue : stepsList) {
                    if (stepsListValue == null) continue;
                    StepConfigJsonMarshaller.getInstance().marshall(stepsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(bootstrapActionsList = (SdkInternalList)runJobFlowRequest.getBootstrapActions()).isEmpty() || !bootstrapActionsList.isAutoConstruct()) {
                jsonWriter.key("BootstrapActions");
                jsonWriter.array();
                for (BootstrapActionConfig bootstrapActionsListValue : bootstrapActionsList) {
                    if (bootstrapActionsListValue == null) continue;
                    BootstrapActionConfigJsonMarshaller.getInstance().marshall(bootstrapActionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(supportedProductsList = (SdkInternalList)runJobFlowRequest.getSupportedProducts()).isEmpty() || !supportedProductsList.isAutoConstruct()) {
                jsonWriter.key("SupportedProducts");
                jsonWriter.array();
                for (String supportedProductsListValue : supportedProductsList) {
                    if (supportedProductsListValue == null) continue;
                    jsonWriter.value((Object)supportedProductsListValue);
                }
                jsonWriter.endArray();
            }
            if (!(newSupportedProductsList = (SdkInternalList)runJobFlowRequest.getNewSupportedProducts()).isEmpty() || !newSupportedProductsList.isAutoConstruct()) {
                jsonWriter.key("NewSupportedProducts");
                jsonWriter.array();
                for (SupportedProductConfig newSupportedProductsListValue : newSupportedProductsList) {
                    if (newSupportedProductsListValue == null) continue;
                    SupportedProductConfigJsonMarshaller.getInstance().marshall(newSupportedProductsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(applicationsList = (SdkInternalList)runJobFlowRequest.getApplications()).isEmpty() || !applicationsList.isAutoConstruct()) {
                jsonWriter.key("Applications");
                jsonWriter.array();
                for (Application applicationsListValue : applicationsList) {
                    if (applicationsListValue == null) continue;
                    ApplicationJsonMarshaller.getInstance().marshall(applicationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(configurationsList = (SdkInternalList)runJobFlowRequest.getConfigurations()).isEmpty() || !configurationsList.isAutoConstruct()) {
                jsonWriter.key("Configurations");
                jsonWriter.array();
                for (Configuration configurationsListValue : configurationsList) {
                    if (configurationsListValue == null) continue;
                    ConfigurationJsonMarshaller.getInstance().marshall(configurationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (runJobFlowRequest.getVisibleToAllUsers() != null) {
                jsonWriter.key("VisibleToAllUsers").value((Object)runJobFlowRequest.getVisibleToAllUsers());
            }
            if (runJobFlowRequest.getJobFlowRole() != null) {
                jsonWriter.key("JobFlowRole").value((Object)runJobFlowRequest.getJobFlowRole());
            }
            if (runJobFlowRequest.getServiceRole() != null) {
                jsonWriter.key("ServiceRole").value((Object)runJobFlowRequest.getServiceRole());
            }
            if (!(tagsList = (SdkInternalList)runJobFlowRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
                jsonWriter.key("Tags");
                jsonWriter.array();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

