/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.Pipeline;
import com.amazonaws.services.elastictranscoder.model.transform.NotificationsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.PipelineOutputConfigJsonMarshaller;

public class PipelineJsonMarshaller {
    private static PipelineJsonMarshaller instance;

    public void marshall(Pipeline pipeline, StructuredJsonGenerator jsonGenerator) {
        if (pipeline == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (pipeline.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(pipeline.getId());
            }
            if (pipeline.getArn() != null) {
                jsonGenerator.writeFieldName("Arn").writeValue(pipeline.getArn());
            }
            if (pipeline.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(pipeline.getName());
            }
            if (pipeline.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(pipeline.getStatus());
            }
            if (pipeline.getInputBucket() != null) {
                jsonGenerator.writeFieldName("InputBucket").writeValue(pipeline.getInputBucket());
            }
            if (pipeline.getOutputBucket() != null) {
                jsonGenerator.writeFieldName("OutputBucket").writeValue(pipeline.getOutputBucket());
            }
            if (pipeline.getRole() != null) {
                jsonGenerator.writeFieldName("Role").writeValue(pipeline.getRole());
            }
            if (pipeline.getAwsKmsKeyArn() != null) {
                jsonGenerator.writeFieldName("AwsKmsKeyArn").writeValue(pipeline.getAwsKmsKeyArn());
            }
            if (pipeline.getNotifications() != null) {
                jsonGenerator.writeFieldName("Notifications");
                NotificationsJsonMarshaller.getInstance().marshall(pipeline.getNotifications(), jsonGenerator);
            }
            if (pipeline.getContentConfig() != null) {
                jsonGenerator.writeFieldName("ContentConfig");
                PipelineOutputConfigJsonMarshaller.getInstance().marshall(pipeline.getContentConfig(), jsonGenerator);
            }
            if (pipeline.getThumbnailConfig() != null) {
                jsonGenerator.writeFieldName("ThumbnailConfig");
                PipelineOutputConfigJsonMarshaller.getInstance().marshall(pipeline.getThumbnailConfig(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineJsonMarshaller();
        }
        return instance;
    }
}

