/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.transform.NotificationsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.PipelineOutputConfigJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreatePipelineRequestMarshaller
implements Marshaller<Request<CreatePipelineRequest>, CreatePipelineRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<CreatePipelineRequest> marshall(CreatePipelineRequest createPipelineRequest) {
        if (createPipelineRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPipelineRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2012-09-25/pipelines";
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createPipelineRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createPipelineRequest.getName());
            }
            if (createPipelineRequest.getInputBucket() != null) {
                jsonGenerator.writeFieldName("InputBucket").writeValue(createPipelineRequest.getInputBucket());
            }
            if (createPipelineRequest.getOutputBucket() != null) {
                jsonGenerator.writeFieldName("OutputBucket").writeValue(createPipelineRequest.getOutputBucket());
            }
            if (createPipelineRequest.getRole() != null) {
                jsonGenerator.writeFieldName("Role").writeValue(createPipelineRequest.getRole());
            }
            if (createPipelineRequest.getAwsKmsKeyArn() != null) {
                jsonGenerator.writeFieldName("AwsKmsKeyArn").writeValue(createPipelineRequest.getAwsKmsKeyArn());
            }
            if (createPipelineRequest.getNotifications() != null) {
                jsonGenerator.writeFieldName("Notifications");
                NotificationsJsonMarshaller.getInstance().marshall(createPipelineRequest.getNotifications(), jsonGenerator);
            }
            if (createPipelineRequest.getContentConfig() != null) {
                jsonGenerator.writeFieldName("ContentConfig");
                PipelineOutputConfigJsonMarshaller.getInstance().marshall(createPipelineRequest.getContentConfig(), jsonGenerator);
            }
            if (createPipelineRequest.getThumbnailConfig() != null) {
                jsonGenerator.writeFieldName("ThumbnailConfig");
                PipelineOutputConfigJsonMarshaller.getInstance().marshall(createPipelineRequest.getThumbnailConfig(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

