/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.Permission;
import com.amazonaws.services.elastictranscoder.model.PipelineOutputConfig;
import com.amazonaws.services.elastictranscoder.model.transform.PermissionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class PipelineOutputConfigJsonMarshaller {
    private static PipelineOutputConfigJsonMarshaller instance;

    public void marshall(PipelineOutputConfig pipelineOutputConfig, JSONWriter jsonWriter) {
        if (pipelineOutputConfig == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList permissionsList;
            jsonWriter.object();
            if (pipelineOutputConfig.getBucket() != null) {
                jsonWriter.key("Bucket").value((Object)pipelineOutputConfig.getBucket());
            }
            if (pipelineOutputConfig.getStorageClass() != null) {
                jsonWriter.key("StorageClass").value((Object)pipelineOutputConfig.getStorageClass());
            }
            if (!(permissionsList = (SdkInternalList)pipelineOutputConfig.getPermissions()).isEmpty() || !permissionsList.isAutoConstruct()) {
                jsonWriter.key("Permissions");
                jsonWriter.array();
                for (Permission permissionsListValue : permissionsList) {
                    if (permissionsListValue == null) continue;
                    PermissionJsonMarshaller.getInstance().marshall(permissionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineOutputConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineOutputConfigJsonMarshaller();
        }
        return instance;
    }
}

