/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoderAsync;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoderClient;
import com.amazonaws.services.elastictranscoder.model.CancelJobRequest;
import com.amazonaws.services.elastictranscoder.model.CancelJobResult;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.CreateJobResult;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.CreatePresetRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePresetResult;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineResult;
import com.amazonaws.services.elastictranscoder.model.DeletePresetRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePresetResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusResult;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesRequest;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesResult;
import com.amazonaws.services.elastictranscoder.model.ListPresetsRequest;
import com.amazonaws.services.elastictranscoder.model.ListPresetsResult;
import com.amazonaws.services.elastictranscoder.model.ReadJobRequest;
import com.amazonaws.services.elastictranscoder.model.ReadJobResult;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ReadPresetRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPresetResult;
import com.amazonaws.services.elastictranscoder.model.TestRoleRequest;
import com.amazonaws.services.elastictranscoder.model.TestRoleResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonElasticTranscoderAsyncClient
extends AmazonElasticTranscoderClient
implements AmazonElasticTranscoderAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonElasticTranscoderAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonElasticTranscoderAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonElasticTranscoderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request) {
        return this.cancelJobAsync(request, null);
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(final CancelJobRequest request, final AsyncHandler<CancelJobRequest, CancelJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                CancelJobResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.cancelJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request) {
        return this.createJobAsync(request, null);
    }

    @Override
    public Future<CreateJobResult> createJobAsync(final CreateJobRequest request, final AsyncHandler<CreateJobRequest, CreateJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateJobResult>(){

            @Override
            public CreateJobResult call() throws Exception {
                CreateJobResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.createJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request) {
        return this.createPipelineAsync(request, null);
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(final CreatePipelineRequest request, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.createPipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePresetResult> createPresetAsync(CreatePresetRequest request) {
        return this.createPresetAsync(request, null);
    }

    @Override
    public Future<CreatePresetResult> createPresetAsync(final CreatePresetRequest request, final AsyncHandler<CreatePresetRequest, CreatePresetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePresetResult>(){

            @Override
            public CreatePresetResult call() throws Exception {
                CreatePresetResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.createPreset(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(DeletePipelineRequest request) {
        return this.deletePipelineAsync(request, null);
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(final DeletePipelineRequest request, final AsyncHandler<DeletePipelineRequest, DeletePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeletePipelineResult>(){

            @Override
            public DeletePipelineResult call() throws Exception {
                DeletePipelineResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.deletePipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePresetResult> deletePresetAsync(DeletePresetRequest request) {
        return this.deletePresetAsync(request, null);
    }

    @Override
    public Future<DeletePresetResult> deletePresetAsync(final DeletePresetRequest request, final AsyncHandler<DeletePresetRequest, DeletePresetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeletePresetResult>(){

            @Override
            public DeletePresetResult call() throws Exception {
                DeletePresetResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.deletePreset(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsByPipelineResult> listJobsByPipelineAsync(ListJobsByPipelineRequest request) {
        return this.listJobsByPipelineAsync(request, null);
    }

    @Override
    public Future<ListJobsByPipelineResult> listJobsByPipelineAsync(final ListJobsByPipelineRequest request, final AsyncHandler<ListJobsByPipelineRequest, ListJobsByPipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListJobsByPipelineResult>(){

            @Override
            public ListJobsByPipelineResult call() throws Exception {
                ListJobsByPipelineResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.listJobsByPipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsByStatusResult> listJobsByStatusAsync(ListJobsByStatusRequest request) {
        return this.listJobsByStatusAsync(request, null);
    }

    @Override
    public Future<ListJobsByStatusResult> listJobsByStatusAsync(final ListJobsByStatusRequest request, final AsyncHandler<ListJobsByStatusRequest, ListJobsByStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListJobsByStatusResult>(){

            @Override
            public ListJobsByStatusResult call() throws Exception {
                ListJobsByStatusResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.listJobsByStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request) {
        return this.listPipelinesAsync(request, null);
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(final ListPipelinesRequest request, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.listPipelines(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync() {
        return this.listPipelinesAsync(new ListPipelinesRequest());
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        return this.listPipelinesAsync(new ListPipelinesRequest(), asyncHandler);
    }

    @Override
    public Future<ListPresetsResult> listPresetsAsync(ListPresetsRequest request) {
        return this.listPresetsAsync(request, null);
    }

    @Override
    public Future<ListPresetsResult> listPresetsAsync(final ListPresetsRequest request, final AsyncHandler<ListPresetsRequest, ListPresetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPresetsResult>(){

            @Override
            public ListPresetsResult call() throws Exception {
                ListPresetsResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.listPresets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPresetsResult> listPresetsAsync() {
        return this.listPresetsAsync(new ListPresetsRequest());
    }

    @Override
    public Future<ListPresetsResult> listPresetsAsync(AsyncHandler<ListPresetsRequest, ListPresetsResult> asyncHandler) {
        return this.listPresetsAsync(new ListPresetsRequest(), asyncHandler);
    }

    @Override
    public Future<ReadJobResult> readJobAsync(ReadJobRequest request) {
        return this.readJobAsync(request, null);
    }

    @Override
    public Future<ReadJobResult> readJobAsync(final ReadJobRequest request, final AsyncHandler<ReadJobRequest, ReadJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<ReadJobResult>(){

            @Override
            public ReadJobResult call() throws Exception {
                ReadJobResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.readJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReadPipelineResult> readPipelineAsync(ReadPipelineRequest request) {
        return this.readPipelineAsync(request, null);
    }

    @Override
    public Future<ReadPipelineResult> readPipelineAsync(final ReadPipelineRequest request, final AsyncHandler<ReadPipelineRequest, ReadPipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<ReadPipelineResult>(){

            @Override
            public ReadPipelineResult call() throws Exception {
                ReadPipelineResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.readPipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReadPresetResult> readPresetAsync(ReadPresetRequest request) {
        return this.readPresetAsync(request, null);
    }

    @Override
    public Future<ReadPresetResult> readPresetAsync(final ReadPresetRequest request, final AsyncHandler<ReadPresetRequest, ReadPresetResult> asyncHandler) {
        return this.executorService.submit(new Callable<ReadPresetResult>(){

            @Override
            public ReadPresetResult call() throws Exception {
                ReadPresetResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.readPreset(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestRoleResult> testRoleAsync(TestRoleRequest request) {
        return this.testRoleAsync(request, null);
    }

    @Override
    public Future<TestRoleResult> testRoleAsync(final TestRoleRequest request, final AsyncHandler<TestRoleRequest, TestRoleResult> asyncHandler) {
        return this.executorService.submit(new Callable<TestRoleResult>(){

            @Override
            public TestRoleResult call() throws Exception {
                TestRoleResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.testRole(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(UpdatePipelineRequest request) {
        return this.updatePipelineAsync(request, null);
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(final UpdatePipelineRequest request, final AsyncHandler<UpdatePipelineRequest, UpdatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() throws Exception {
                UpdatePipelineResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.updatePipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineNotificationsResult> updatePipelineNotificationsAsync(UpdatePipelineNotificationsRequest request) {
        return this.updatePipelineNotificationsAsync(request, null);
    }

    @Override
    public Future<UpdatePipelineNotificationsResult> updatePipelineNotificationsAsync(final UpdatePipelineNotificationsRequest request, final AsyncHandler<UpdatePipelineNotificationsRequest, UpdatePipelineNotificationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdatePipelineNotificationsResult>(){

            @Override
            public UpdatePipelineNotificationsResult call() throws Exception {
                UpdatePipelineNotificationsResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.updatePipelineNotifications(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineStatusResult> updatePipelineStatusAsync(UpdatePipelineStatusRequest request) {
        return this.updatePipelineStatusAsync(request, null);
    }

    @Override
    public Future<UpdatePipelineStatusResult> updatePipelineStatusAsync(final UpdatePipelineStatusRequest request, final AsyncHandler<UpdatePipelineStatusRequest, UpdatePipelineStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdatePipelineStatusResult>(){

            @Override
            public UpdatePipelineStatusResult call() throws Exception {
                UpdatePipelineStatusResult result;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.updatePipelineStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

