/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elastictranscoder.model.CaptionFormat;
import com.amazonaws.services.elastictranscoder.model.transform.EncryptionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class CaptionFormatJsonMarshaller {
    private static CaptionFormatJsonMarshaller instance;

    public void marshall(CaptionFormat captionFormat, JSONWriter jsonWriter) {
        if (captionFormat == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (captionFormat.getFormat() != null) {
                jsonWriter.key("Format").value((Object)captionFormat.getFormat());
            }
            if (captionFormat.getPattern() != null) {
                jsonWriter.key("Pattern").value((Object)captionFormat.getPattern());
            }
            if (captionFormat.getEncryption() != null) {
                jsonWriter.key("Encryption");
                EncryptionJsonMarshaller.getInstance().marshall(captionFormat.getEncryption(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CaptionFormatJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CaptionFormatJsonMarshaller();
        }
        return instance;
    }
}

