/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.ReadJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ReadJobRequestMarshaller
implements Marshaller<Request<ReadJobRequest>, ReadJobRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<ReadJobRequest> marshall(ReadJobRequest readJobRequest) {
        if (readJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)readJobRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2012-09-25/jobs/{Id}";
        uriResourcePath = uriResourcePath.replace("{Id}", readJobRequest.getId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)readJobRequest.getId()));
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

