/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.Clip;
import com.amazonaws.services.elastictranscoder.model.CreateJobOutput;
import com.amazonaws.services.elastictranscoder.model.JobWatermark;
import com.amazonaws.services.elastictranscoder.model.transform.CaptionsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ClipJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.EncryptionJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.JobAlbumArtJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.JobWatermarkJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class CreateJobOutputJsonMarshaller {
    private static CreateJobOutputJsonMarshaller instance;

    public void marshall(CreateJobOutput createJobOutput, JSONWriter jsonWriter) {
        if (createJobOutput == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList compositionList;
            SdkInternalList watermarksList;
            jsonWriter.object();
            if (createJobOutput.getKey() != null) {
                jsonWriter.key("Key").value((Object)createJobOutput.getKey());
            }
            if (createJobOutput.getThumbnailPattern() != null) {
                jsonWriter.key("ThumbnailPattern").value((Object)createJobOutput.getThumbnailPattern());
            }
            if (createJobOutput.getThumbnailEncryption() != null) {
                jsonWriter.key("ThumbnailEncryption");
                EncryptionJsonMarshaller.getInstance().marshall(createJobOutput.getThumbnailEncryption(), jsonWriter);
            }
            if (createJobOutput.getRotate() != null) {
                jsonWriter.key("Rotate").value((Object)createJobOutput.getRotate());
            }
            if (createJobOutput.getPresetId() != null) {
                jsonWriter.key("PresetId").value((Object)createJobOutput.getPresetId());
            }
            if (createJobOutput.getSegmentDuration() != null) {
                jsonWriter.key("SegmentDuration").value((Object)createJobOutput.getSegmentDuration());
            }
            if (!(watermarksList = (SdkInternalList)createJobOutput.getWatermarks()).isEmpty() || !watermarksList.isAutoConstruct()) {
                jsonWriter.key("Watermarks");
                jsonWriter.array();
                for (JobWatermark watermarksListValue : watermarksList) {
                    if (watermarksListValue == null) continue;
                    JobWatermarkJsonMarshaller.getInstance().marshall(watermarksListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (createJobOutput.getAlbumArt() != null) {
                jsonWriter.key("AlbumArt");
                JobAlbumArtJsonMarshaller.getInstance().marshall(createJobOutput.getAlbumArt(), jsonWriter);
            }
            if (!(compositionList = (SdkInternalList)createJobOutput.getComposition()).isEmpty() || !compositionList.isAutoConstruct()) {
                jsonWriter.key("Composition");
                jsonWriter.array();
                for (Clip compositionListValue : compositionList) {
                    if (compositionListValue == null) continue;
                    ClipJsonMarshaller.getInstance().marshall(compositionListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (createJobOutput.getCaptions() != null) {
                jsonWriter.key("Captions");
                CaptionsJsonMarshaller.getInstance().marshall(createJobOutput.getCaptions(), jsonWriter);
            }
            if (createJobOutput.getEncryption() != null) {
                jsonWriter.key("Encryption");
                EncryptionJsonMarshaller.getInstance().marshall(createJobOutput.getEncryption(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CreateJobOutputJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CreateJobOutputJsonMarshaller();
        }
        return instance;
    }
}

