/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elastictranscoder.model.JobInput;
import com.amazonaws.services.elastictranscoder.model.transform.DetectedPropertiesJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.EncryptionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class JobInputJsonMarshaller {
    private static JobInputJsonMarshaller instance;

    public void marshall(JobInput jobInput, JSONWriter jsonWriter) {
        if (jobInput == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (jobInput.getKey() != null) {
                jsonWriter.key("Key").value((Object)jobInput.getKey());
            }
            if (jobInput.getFrameRate() != null) {
                jsonWriter.key("FrameRate").value((Object)jobInput.getFrameRate());
            }
            if (jobInput.getResolution() != null) {
                jsonWriter.key("Resolution").value((Object)jobInput.getResolution());
            }
            if (jobInput.getAspectRatio() != null) {
                jsonWriter.key("AspectRatio").value((Object)jobInput.getAspectRatio());
            }
            if (jobInput.getInterlaced() != null) {
                jsonWriter.key("Interlaced").value((Object)jobInput.getInterlaced());
            }
            if (jobInput.getContainer() != null) {
                jsonWriter.key("Container").value((Object)jobInput.getContainer());
            }
            if (jobInput.getEncryption() != null) {
                jsonWriter.key("Encryption");
                EncryptionJsonMarshaller.getInstance().marshall(jobInput.getEncryption(), jsonWriter);
            }
            if (jobInput.getDetectedProperties() != null) {
                jsonWriter.key("DetectedProperties");
                DetectedPropertiesJsonMarshaller.getInstance().marshall(jobInput.getDetectedProperties(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobInputJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobInputJsonMarshaller();
        }
        return instance;
    }
}

