/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elastictranscoder.model.Artwork;
import com.amazonaws.services.elastictranscoder.model.transform.EncryptionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ArtworkJsonMarshaller {
    private static ArtworkJsonMarshaller instance;

    public void marshall(Artwork artwork, JSONWriter jsonWriter) {
        if (artwork == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (artwork.getInputKey() != null) {
                jsonWriter.key("InputKey").value((Object)artwork.getInputKey());
            }
            if (artwork.getMaxWidth() != null) {
                jsonWriter.key("MaxWidth").value((Object)artwork.getMaxWidth());
            }
            if (artwork.getMaxHeight() != null) {
                jsonWriter.key("MaxHeight").value((Object)artwork.getMaxHeight());
            }
            if (artwork.getSizingPolicy() != null) {
                jsonWriter.key("SizingPolicy").value((Object)artwork.getSizingPolicy());
            }
            if (artwork.getPaddingPolicy() != null) {
                jsonWriter.key("PaddingPolicy").value((Object)artwork.getPaddingPolicy());
            }
            if (artwork.getAlbumArtFormat() != null) {
                jsonWriter.key("AlbumArtFormat").value((Object)artwork.getAlbumArtFormat());
            }
            if (artwork.getEncryption() != null) {
                jsonWriter.key("Encryption");
                EncryptionJsonMarshaller.getInstance().marshall(artwork.getEncryption(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ArtworkJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ArtworkJsonMarshaller();
        }
        return instance;
    }
}

