/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticsearch.model.ListTagsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListTagsRequestMarshaller
implements Marshaller<Request<ListTagsRequest>, ListTagsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<ListTagsRequest> marshall(ListTagsRequest listTagsRequest) {
        String aRN;
        if (listTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTagsRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-01-01/tags/";
        request.setResourcePath(uriResourcePath);
        String string = aRN = listTagsRequest.getARN() == null ? null : StringUtils.fromString((String)listTagsRequest.getARN());
        if (aRN != null) {
            request.addParameter("arn", aRN);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

