/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeLoadBalancersRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancersRequest>, DescribeLoadBalancersRequest> {
    public Request<DescribeLoadBalancersRequest> marshall(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        if (describeLoadBalancersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLoadBalancersRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeLoadBalancers");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeLoadBalancersRequest.getLoadBalancerArns() != null) {
            List<String> loadBalancerArnsList = describeLoadBalancersRequest.getLoadBalancerArns();
            if (loadBalancerArnsList.isEmpty()) {
                request.addParameter("LoadBalancerArns", "");
            } else {
                int loadBalancerArnsListIndex = 1;
                for (String loadBalancerArnsListValue : loadBalancerArnsList) {
                    if (loadBalancerArnsListValue != null) {
                        request.addParameter("LoadBalancerArns.member." + loadBalancerArnsListIndex, StringUtils.fromString((String)loadBalancerArnsListValue));
                    }
                    ++loadBalancerArnsListIndex;
                }
            }
        }
        if (describeLoadBalancersRequest.getNames() != null) {
            List<String> namesList = describeLoadBalancersRequest.getNames();
            if (namesList.isEmpty()) {
                request.addParameter("Names", "");
            } else {
                int namesListIndex = 1;
                for (String namesListValue : namesList) {
                    if (namesListValue != null) {
                        request.addParameter("Names.member." + namesListIndex, StringUtils.fromString((String)namesListValue));
                    }
                    ++namesListIndex;
                }
            }
        }
        if (describeLoadBalancersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeLoadBalancersRequest.getMarker()));
        }
        if (describeLoadBalancersRequest.getPageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeLoadBalancersRequest.getPageSize()));
        }
        return request;
    }
}

