/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.Matcher;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyTargetGroupRequestMarshaller
implements Marshaller<Request<ModifyTargetGroupRequest>, ModifyTargetGroupRequest> {
    public Request<ModifyTargetGroupRequest> marshall(ModifyTargetGroupRequest modifyTargetGroupRequest) {
        Matcher matcher;
        if (modifyTargetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyTargetGroupRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyTargetGroup");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyTargetGroupRequest.getTargetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString((String)modifyTargetGroupRequest.getTargetGroupArn()));
        }
        if (modifyTargetGroupRequest.getHealthCheckProtocol() != null) {
            request.addParameter("HealthCheckProtocol", StringUtils.fromString((String)modifyTargetGroupRequest.getHealthCheckProtocol()));
        }
        if (modifyTargetGroupRequest.getHealthCheckPort() != null) {
            request.addParameter("HealthCheckPort", StringUtils.fromString((String)modifyTargetGroupRequest.getHealthCheckPort()));
        }
        if (modifyTargetGroupRequest.getHealthCheckPath() != null) {
            request.addParameter("HealthCheckPath", StringUtils.fromString((String)modifyTargetGroupRequest.getHealthCheckPath()));
        }
        if (modifyTargetGroupRequest.getHealthCheckEnabled() != null) {
            request.addParameter("HealthCheckEnabled", StringUtils.fromBoolean((Boolean)modifyTargetGroupRequest.getHealthCheckEnabled()));
        }
        if (modifyTargetGroupRequest.getHealthCheckIntervalSeconds() != null) {
            request.addParameter("HealthCheckIntervalSeconds", StringUtils.fromInteger((Integer)modifyTargetGroupRequest.getHealthCheckIntervalSeconds()));
        }
        if (modifyTargetGroupRequest.getHealthCheckTimeoutSeconds() != null) {
            request.addParameter("HealthCheckTimeoutSeconds", StringUtils.fromInteger((Integer)modifyTargetGroupRequest.getHealthCheckTimeoutSeconds()));
        }
        if (modifyTargetGroupRequest.getHealthyThresholdCount() != null) {
            request.addParameter("HealthyThresholdCount", StringUtils.fromInteger((Integer)modifyTargetGroupRequest.getHealthyThresholdCount()));
        }
        if (modifyTargetGroupRequest.getUnhealthyThresholdCount() != null) {
            request.addParameter("UnhealthyThresholdCount", StringUtils.fromInteger((Integer)modifyTargetGroupRequest.getUnhealthyThresholdCount()));
        }
        if ((matcher = modifyTargetGroupRequest.getMatcher()) != null) {
            if (matcher.getHttpCode() != null) {
                request.addParameter("Matcher.HttpCode", StringUtils.fromString((String)matcher.getHttpCode()));
            }
            if (matcher.getGrpcCode() != null) {
                request.addParameter("Matcher.GrpcCode", StringUtils.fromString((String)matcher.getGrpcCode()));
            }
        }
        return request;
    }
}

