/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeTrustStoresRequestMarshaller
implements Marshaller<Request<DescribeTrustStoresRequest>, DescribeTrustStoresRequest> {
    public Request<DescribeTrustStoresRequest> marshall(DescribeTrustStoresRequest describeTrustStoresRequest) {
        if (describeTrustStoresRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTrustStoresRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeTrustStores");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeTrustStoresRequest.getTrustStoreArns() != null) {
            List<String> trustStoreArnsList = describeTrustStoresRequest.getTrustStoreArns();
            if (trustStoreArnsList.isEmpty()) {
                request.addParameter("TrustStoreArns", "");
            } else {
                int trustStoreArnsListIndex = 1;
                for (String trustStoreArnsListValue : trustStoreArnsList) {
                    if (trustStoreArnsListValue != null) {
                        request.addParameter("TrustStoreArns.member." + trustStoreArnsListIndex, StringUtils.fromString((String)trustStoreArnsListValue));
                    }
                    ++trustStoreArnsListIndex;
                }
            }
        }
        if (describeTrustStoresRequest.getNames() != null) {
            List<String> namesList = describeTrustStoresRequest.getNames();
            if (namesList.isEmpty()) {
                request.addParameter("Names", "");
            } else {
                int namesListIndex = 1;
                for (String namesListValue : namesList) {
                    if (namesListValue != null) {
                        request.addParameter("Names.member." + namesListIndex, StringUtils.fromString((String)namesListValue));
                    }
                    ++namesListIndex;
                }
            }
        }
        if (describeTrustStoresRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeTrustStoresRequest.getMarker()));
        }
        if (describeTrustStoresRequest.getPageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeTrustStoresRequest.getPageSize()));
        }
        return request;
    }
}

