/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.AddTrustStoreRevocationsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.RevocationContent;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AddTrustStoreRevocationsRequestMarshaller
implements Marshaller<Request<AddTrustStoreRevocationsRequest>, AddTrustStoreRevocationsRequest> {
    public Request<AddTrustStoreRevocationsRequest> marshall(AddTrustStoreRevocationsRequest addTrustStoreRevocationsRequest) {
        if (addTrustStoreRevocationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addTrustStoreRevocationsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "AddTrustStoreRevocations");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (addTrustStoreRevocationsRequest.getTrustStoreArn() != null) {
            request.addParameter("TrustStoreArn", StringUtils.fromString((String)addTrustStoreRevocationsRequest.getTrustStoreArn()));
        }
        if (addTrustStoreRevocationsRequest.getRevocationContents() != null) {
            List<RevocationContent> revocationContentsList = addTrustStoreRevocationsRequest.getRevocationContents();
            if (revocationContentsList.isEmpty()) {
                request.addParameter("RevocationContents", "");
            } else {
                int revocationContentsListIndex = 1;
                for (RevocationContent revocationContentsListValue : revocationContentsList) {
                    if (revocationContentsListValue != null) {
                        if (revocationContentsListValue.getS3Bucket() != null) {
                            request.addParameter("RevocationContents.member." + revocationContentsListIndex + ".S3Bucket", StringUtils.fromString((String)revocationContentsListValue.getS3Bucket()));
                        }
                        if (revocationContentsListValue.getS3Key() != null) {
                            request.addParameter("RevocationContents.member." + revocationContentsListIndex + ".S3Key", StringUtils.fromString((String)revocationContentsListValue.getS3Key()));
                        }
                        if (revocationContentsListValue.getS3ObjectVersion() != null) {
                            request.addParameter("RevocationContents.member." + revocationContentsListIndex + ".S3ObjectVersion", StringUtils.fromString((String)revocationContentsListValue.getS3ObjectVersion()));
                        }
                        if (revocationContentsListValue.getRevocationType() != null) {
                            request.addParameter("RevocationContents.member." + revocationContentsListIndex + ".RevocationType", StringUtils.fromString((String)revocationContentsListValue.getRevocationType()));
                        }
                    }
                    ++revocationContentsListIndex;
                }
            }
        }
        return request;
    }
}

