/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.RulePriorityPair;
import com.amazonaws.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SetRulePrioritiesRequestMarshaller
implements Marshaller<Request<SetRulePrioritiesRequest>, SetRulePrioritiesRequest> {
    public Request<SetRulePrioritiesRequest> marshall(SetRulePrioritiesRequest setRulePrioritiesRequest) {
        if (setRulePrioritiesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setRulePrioritiesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "SetRulePriorities");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setRulePrioritiesRequest.getRulePriorities() != null) {
            List<RulePriorityPair> rulePrioritiesList = setRulePrioritiesRequest.getRulePriorities();
            if (rulePrioritiesList.isEmpty()) {
                request.addParameter("RulePriorities", "");
            } else {
                int rulePrioritiesListIndex = 1;
                for (RulePriorityPair rulePrioritiesListValue : rulePrioritiesList) {
                    if (rulePrioritiesListValue.getRuleArn() != null) {
                        request.addParameter("RulePriorities.member." + rulePrioritiesListIndex + ".RuleArn", StringUtils.fromString((String)rulePrioritiesListValue.getRuleArn()));
                    }
                    if (rulePrioritiesListValue.getPriority() != null) {
                        request.addParameter("RulePriorities.member." + rulePrioritiesListIndex + ".Priority", StringUtils.fromInteger((Integer)rulePrioritiesListValue.getPriority()));
                    }
                    ++rulePrioritiesListIndex;
                }
            }
        }
        return request;
    }
}

