/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancingv2.waiters.DescribeLoadBalancersFunction;
import com.amazonaws.services.elasticloadbalancingv2.waiters.LoadBalancerAvailable;
import com.amazonaws.services.elasticloadbalancingv2.waiters.LoadBalancerExists;
import com.amazonaws.services.elasticloadbalancingv2.waiters.LoadBalancersDeleted;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonElasticLoadBalancingWaiters {
    private final AmazonElasticLoadBalancing client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonElasticLoadBalancingWaiters(AmazonElasticLoadBalancing client) {
        this.client = client;
    }

    public Waiter<DescribeLoadBalancersRequest> loadBalancerAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeLoadBalancersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new LoadBalancerAvailable.IsActiveMatcher(), new LoadBalancerAvailable.IsProvisioningMatcher(), new LoadBalancerAvailable.IsLoadBalancerNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeLoadBalancersRequest> loadBalancerExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeLoadBalancersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new LoadBalancerExists.IsLoadBalancerNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeLoadBalancersRequest> loadBalancersDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeLoadBalancersFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new LoadBalancersDeleted.IsActiveMatcher(), new LoadBalancersDeleted.IsLoadBalancerNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

