/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteLoadBalancerListenersRequestMarshaller
implements Marshaller<Request<DeleteLoadBalancerListenersRequest>, DeleteLoadBalancerListenersRequest> {
    public Request<DeleteLoadBalancerListenersRequest> marshall(DeleteLoadBalancerListenersRequest deleteLoadBalancerListenersRequest) {
        SdkInternalList loadBalancerPortsList;
        if (deleteLoadBalancerListenersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteLoadBalancerListenersRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DeleteLoadBalancerListeners");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteLoadBalancerListenersRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)deleteLoadBalancerListenersRequest.getLoadBalancerName()));
        }
        if (!(loadBalancerPortsList = (SdkInternalList)deleteLoadBalancerListenersRequest.getLoadBalancerPorts()).isEmpty() || !loadBalancerPortsList.isAutoConstruct()) {
            int loadBalancerPortsListIndex = 1;
            for (Integer loadBalancerPortsListValue : loadBalancerPortsList) {
                if (loadBalancerPortsListValue != null) {
                    request.addParameter("LoadBalancerPorts.member." + loadBalancerPortsListIndex, StringUtils.fromInteger((Integer)loadBalancerPortsListValue));
                }
                ++loadBalancerPortsListIndex;
            }
        }
        return request;
    }
}

