/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.SearchFilter;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class SearchFilterStaxUnmarshaller
implements Unmarshaller<SearchFilter, StaxUnmarshallerContext> {
    private static SearchFilterStaxUnmarshaller instance;

    public SearchFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        SearchFilter searchFilter = new SearchFilter();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return searchFilter;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Attribute", targetDepth)) {
                    searchFilter.setAttribute(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Operator", targetDepth)) {
                    searchFilter.setOperator(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Values", targetDepth)) {
                    searchFilter.withValues(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Values/member", targetDepth)) continue;
                searchFilter.withValues(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return searchFilter;
    }

    public static SearchFilterStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SearchFilterStaxUnmarshaller();
        }
        return instance;
    }
}

