/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class DescribeEventsRequestMarshaller
implements Marshaller<Request<DescribeEventsRequest>, DescribeEventsRequest> {
    public Request<DescribeEventsRequest> marshall(DescribeEventsRequest describeEventsRequest) {
        if (describeEventsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEventsRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DescribeEvents");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEventsRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)describeEventsRequest.getApplicationName()));
        }
        if (describeEventsRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)describeEventsRequest.getVersionLabel()));
        }
        if (describeEventsRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)describeEventsRequest.getTemplateName()));
        }
        if (describeEventsRequest.getEnvironmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)describeEventsRequest.getEnvironmentId()));
        }
        if (describeEventsRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)describeEventsRequest.getEnvironmentName()));
        }
        if (describeEventsRequest.getPlatformArn() != null) {
            request.addParameter("PlatformArn", StringUtils.fromString((String)describeEventsRequest.getPlatformArn()));
        }
        if (describeEventsRequest.getRequestId() != null) {
            request.addParameter("RequestId", StringUtils.fromString((String)describeEventsRequest.getRequestId()));
        }
        if (describeEventsRequest.getSeverity() != null) {
            request.addParameter("Severity", StringUtils.fromString((String)describeEventsRequest.getSeverity()));
        }
        if (describeEventsRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)describeEventsRequest.getStartTime()));
        }
        if (describeEventsRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)describeEventsRequest.getEndTime()));
        }
        if (describeEventsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeEventsRequest.getMaxRecords()));
        }
        if (describeEventsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeEventsRequest.getNextToken()));
        }
        return request;
    }
}

