/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ListPlatformBranchesRequest;
import com.amazonaws.services.elasticbeanstalk.model.SearchFilter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListPlatformBranchesRequestMarshaller
implements Marshaller<Request<ListPlatformBranchesRequest>, ListPlatformBranchesRequest> {
    public Request<ListPlatformBranchesRequest> marshall(ListPlatformBranchesRequest listPlatformBranchesRequest) {
        if (listPlatformBranchesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPlatformBranchesRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "ListPlatformBranches");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (!listPlatformBranchesRequest.getFilters().isEmpty() || !((SdkInternalList)listPlatformBranchesRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)listPlatformBranchesRequest.getFilters();
            int filtersListIndex = 1;
            for (SearchFilter filtersListValue : filtersList) {
                if (filtersListValue.getAttribute() != null) {
                    request.addParameter("Filters.member." + filtersListIndex + ".Attribute", StringUtils.fromString((String)filtersListValue.getAttribute()));
                }
                if (filtersListValue.getOperator() != null) {
                    request.addParameter("Filters.member." + filtersListIndex + ".Operator", StringUtils.fromString((String)filtersListValue.getOperator()));
                }
                if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                    SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.member." + filtersListIndex + ".Values.member." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (listPlatformBranchesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)listPlatformBranchesRequest.getMaxRecords()));
        }
        if (listPlatformBranchesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listPlatformBranchesRequest.getNextToken()));
        }
        return request;
    }
}

