/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CheckDNSAvailabilityRequestMarshaller
implements Marshaller<Request<CheckDNSAvailabilityRequest>, CheckDNSAvailabilityRequest> {
    public Request<CheckDNSAvailabilityRequest> marshall(CheckDNSAvailabilityRequest checkDNSAvailabilityRequest) {
        if (checkDNSAvailabilityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)checkDNSAvailabilityRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CheckDNSAvailability");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (checkDNSAvailabilityRequest.getCNAMEPrefix() != null) {
            request.addParameter("CNAMEPrefix", StringUtils.fromString((String)checkDNSAvailabilityRequest.getCNAMEPrefix()));
        }
        return request;
    }
}

