/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.ApplicationDescription;
import com.amazonaws.services.elasticbeanstalk.model.transform.ApplicationResourceLifecycleConfigStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ApplicationDescriptionStaxUnmarshaller
implements Unmarshaller<ApplicationDescription, StaxUnmarshallerContext> {
    private static ApplicationDescriptionStaxUnmarshaller instance;

    public ApplicationDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        ApplicationDescription applicationDescription = new ApplicationDescription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return applicationDescription;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ApplicationName", targetDepth)) {
                    applicationDescription.setApplicationName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    applicationDescription.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DateCreated", targetDepth)) {
                    applicationDescription.setDateCreated(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DateUpdated", targetDepth)) {
                    applicationDescription.setDateUpdated(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Versions", targetDepth)) {
                    applicationDescription.withVersions(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Versions/member", targetDepth)) {
                    applicationDescription.withVersions(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ConfigurationTemplates", targetDepth)) {
                    applicationDescription.withConfigurationTemplates(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ConfigurationTemplates/member", targetDepth)) {
                    applicationDescription.withConfigurationTemplates(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ResourceLifecycleConfig", targetDepth)) continue;
                applicationDescription.setResourceLifecycleConfig(ApplicationResourceLifecycleConfigStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return applicationDescription;
    }

    public static ApplicationDescriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ApplicationDescriptionStaxUnmarshaller();
        }
        return instance;
    }
}

