/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.SingleInstanceHealth;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DescribeInstancesHealthResult
implements Serializable,
Cloneable {
    private SdkInternalList<SingleInstanceHealth> instanceHealthList;
    private Date refreshedAt;
    private String nextToken;

    public List<SingleInstanceHealth> getInstanceHealthList() {
        if (this.instanceHealthList == null) {
            this.instanceHealthList = new SdkInternalList();
        }
        return this.instanceHealthList;
    }

    public void setInstanceHealthList(Collection<SingleInstanceHealth> instanceHealthList) {
        if (instanceHealthList == null) {
            this.instanceHealthList = null;
            return;
        }
        this.instanceHealthList = new SdkInternalList(instanceHealthList);
    }

    public DescribeInstancesHealthResult withInstanceHealthList(SingleInstanceHealth ... instanceHealthList) {
        if (this.instanceHealthList == null) {
            this.setInstanceHealthList((Collection<SingleInstanceHealth>)new SdkInternalList(instanceHealthList.length));
        }
        for (SingleInstanceHealth ele : instanceHealthList) {
            this.instanceHealthList.add((Object)ele);
        }
        return this;
    }

    public DescribeInstancesHealthResult withInstanceHealthList(Collection<SingleInstanceHealth> instanceHealthList) {
        this.setInstanceHealthList(instanceHealthList);
        return this;
    }

    public void setRefreshedAt(Date refreshedAt) {
        this.refreshedAt = refreshedAt;
    }

    public Date getRefreshedAt() {
        return this.refreshedAt;
    }

    public DescribeInstancesHealthResult withRefreshedAt(Date refreshedAt) {
        this.setRefreshedAt(refreshedAt);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeInstancesHealthResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceHealthList() != null) {
            sb.append("InstanceHealthList: " + this.getInstanceHealthList() + ",");
        }
        if (this.getRefreshedAt() != null) {
            sb.append("RefreshedAt: " + this.getRefreshedAt() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesHealthResult)) {
            return false;
        }
        DescribeInstancesHealthResult other = (DescribeInstancesHealthResult)obj;
        if (other.getInstanceHealthList() == null ^ this.getInstanceHealthList() == null) {
            return false;
        }
        if (other.getInstanceHealthList() != null && !other.getInstanceHealthList().equals(this.getInstanceHealthList())) {
            return false;
        }
        if (other.getRefreshedAt() == null ^ this.getRefreshedAt() == null) {
            return false;
        }
        if (other.getRefreshedAt() != null && !other.getRefreshedAt().equals(this.getRefreshedAt())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceHealthList() == null ? 0 : this.getInstanceHealthList().hashCode());
        hashCode = 31 * hashCode + (this.getRefreshedAt() == null ? 0 : this.getRefreshedAt().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeInstancesHealthResult clone() {
        try {
            return (DescribeInstancesHealthResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

