/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier;
import com.amazonaws.services.elasticbeanstalk.model.OptionSpecification;
import com.amazonaws.services.elasticbeanstalk.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateEnvironmentRequestMarshaller
implements Marshaller<Request<CreateEnvironmentRequest>, CreateEnvironmentRequest> {
    public Request<CreateEnvironmentRequest> marshall(CreateEnvironmentRequest createEnvironmentRequest) {
        SdkInternalList optionsToRemoveList;
        SdkInternalList optionSettingsList;
        SdkInternalList tagsList;
        EnvironmentTier tier;
        if (createEnvironmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createEnvironmentRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createEnvironmentRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)createEnvironmentRequest.getApplicationName()));
        }
        if (createEnvironmentRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)createEnvironmentRequest.getEnvironmentName()));
        }
        if (createEnvironmentRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createEnvironmentRequest.getDescription()));
        }
        if (createEnvironmentRequest.getCNAMEPrefix() != null) {
            request.addParameter("CNAMEPrefix", StringUtils.fromString((String)createEnvironmentRequest.getCNAMEPrefix()));
        }
        if ((tier = createEnvironmentRequest.getTier()) != null) {
            if (tier.getName() != null) {
                request.addParameter("Tier.Name", StringUtils.fromString((String)tier.getName()));
            }
            if (tier.getType() != null) {
                request.addParameter("Tier.Type", StringUtils.fromString((String)tier.getType()));
            }
            if (tier.getVersion() != null) {
                request.addParameter("Tier.Version", StringUtils.fromString((String)tier.getVersion()));
            }
        }
        if (!(tagsList = (SdkInternalList)createEnvironmentRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (createEnvironmentRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)createEnvironmentRequest.getVersionLabel()));
        }
        if (createEnvironmentRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)createEnvironmentRequest.getTemplateName()));
        }
        if (createEnvironmentRequest.getSolutionStackName() != null) {
            request.addParameter("SolutionStackName", StringUtils.fromString((String)createEnvironmentRequest.getSolutionStackName()));
        }
        if (!(optionSettingsList = (SdkInternalList)createEnvironmentRequest.getOptionSettings()).isEmpty() || !optionSettingsList.isAutoConstruct()) {
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.getResourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString((String)optionSettingsListValue.getResourceName()));
                }
                if (optionSettingsListValue.getNamespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)optionSettingsListValue.getNamespace()));
                }
                if (optionSettingsListValue.getOptionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)optionSettingsListValue.getOptionName()));
                }
                if (optionSettingsListValue.getValue() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.getValue()));
                }
                ++optionSettingsListIndex;
            }
        }
        if (!(optionsToRemoveList = (SdkInternalList)createEnvironmentRequest.getOptionsToRemove()).isEmpty() || !optionsToRemoveList.isAutoConstruct()) {
            int optionsToRemoveListIndex = 1;
            for (OptionSpecification optionsToRemoveListValue : optionsToRemoveList) {
                if (optionsToRemoveListValue.getResourceName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".ResourceName", StringUtils.fromString((String)optionsToRemoveListValue.getResourceName()));
                }
                if (optionsToRemoveListValue.getNamespace() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".Namespace", StringUtils.fromString((String)optionsToRemoveListValue.getNamespace()));
                }
                if (optionsToRemoveListValue.getOptionName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".OptionName", StringUtils.fromString((String)optionsToRemoveListValue.getOptionName()));
                }
                ++optionsToRemoveListIndex;
            }
        }
        return request;
    }
}

