/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CustomerNodeEndpoint;
import com.amazonaws.services.elasticache.model.TestMigrationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class TestMigrationRequestMarshaller
implements Marshaller<Request<TestMigrationRequest>, TestMigrationRequest> {
    public Request<TestMigrationRequest> marshall(TestMigrationRequest testMigrationRequest) {
        if (testMigrationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)testMigrationRequest, "AmazonElastiCache");
        request.addParameter("Action", "TestMigration");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (testMigrationRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)testMigrationRequest.getReplicationGroupId()));
        }
        if (!testMigrationRequest.getCustomerNodeEndpointList().isEmpty() || !((SdkInternalList)testMigrationRequest.getCustomerNodeEndpointList()).isAutoConstruct()) {
            SdkInternalList customerNodeEndpointListList = (SdkInternalList)testMigrationRequest.getCustomerNodeEndpointList();
            int customerNodeEndpointListListIndex = 1;
            for (CustomerNodeEndpoint customerNodeEndpointListListValue : customerNodeEndpointListList) {
                if (customerNodeEndpointListListValue != null) {
                    if (customerNodeEndpointListListValue.getAddress() != null) {
                        request.addParameter("CustomerNodeEndpointList.member." + customerNodeEndpointListListIndex + ".Address", StringUtils.fromString((String)customerNodeEndpointListListValue.getAddress()));
                    }
                    if (customerNodeEndpointListListValue.getPort() != null) {
                        request.addParameter("CustomerNodeEndpointList.member." + customerNodeEndpointListListIndex + ".Port", StringUtils.fromInteger((Integer)customerNodeEndpointListListValue.getPort()));
                    }
                }
                ++customerNodeEndpointListListIndex;
            }
        }
        return request;
    }
}

