/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CreateSnapshotRequest;
import com.amazonaws.services.elasticache.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateSnapshotRequestMarshaller
implements Marshaller<Request<CreateSnapshotRequest>, CreateSnapshotRequest> {
    public Request<CreateSnapshotRequest> marshall(CreateSnapshotRequest createSnapshotRequest) {
        if (createSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSnapshotRequest, "AmazonElastiCache");
        request.addParameter("Action", "CreateSnapshot");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSnapshotRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)createSnapshotRequest.getReplicationGroupId()));
        }
        if (createSnapshotRequest.getCacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)createSnapshotRequest.getCacheClusterId()));
        }
        if (createSnapshotRequest.getSnapshotName() != null) {
            request.addParameter("SnapshotName", StringUtils.fromString((String)createSnapshotRequest.getSnapshotName()));
        }
        if (createSnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createSnapshotRequest.getKmsKeyId()));
        }
        if (!createSnapshotRequest.getTags().isEmpty() || !((SdkInternalList)createSnapshotRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createSnapshotRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

