/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.AddonVersionInfo;
import com.amazonaws.services.eks.model.transform.AddonInfoMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddonInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private String addonName;
    private String type;
    private List<AddonVersionInfo> addonVersions;

    public void setAddonName(String addonName) {
        this.addonName = addonName;
    }

    public String getAddonName() {
        return this.addonName;
    }

    public AddonInfo withAddonName(String addonName) {
        this.setAddonName(addonName);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public AddonInfo withType(String type) {
        this.setType(type);
        return this;
    }

    public List<AddonVersionInfo> getAddonVersions() {
        return this.addonVersions;
    }

    public void setAddonVersions(Collection<AddonVersionInfo> addonVersions) {
        if (addonVersions == null) {
            this.addonVersions = null;
            return;
        }
        this.addonVersions = new ArrayList<AddonVersionInfo>(addonVersions);
    }

    public AddonInfo withAddonVersions(AddonVersionInfo ... addonVersions) {
        if (this.addonVersions == null) {
            this.setAddonVersions(new ArrayList<AddonVersionInfo>(addonVersions.length));
        }
        for (AddonVersionInfo ele : addonVersions) {
            this.addonVersions.add(ele);
        }
        return this;
    }

    public AddonInfo withAddonVersions(Collection<AddonVersionInfo> addonVersions) {
        this.setAddonVersions(addonVersions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAddonName() != null) {
            sb.append("AddonName: ").append(this.getAddonName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getAddonVersions() != null) {
            sb.append("AddonVersions: ").append(this.getAddonVersions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonInfo)) {
            return false;
        }
        AddonInfo other = (AddonInfo)obj;
        if (other.getAddonName() == null ^ this.getAddonName() == null) {
            return false;
        }
        if (other.getAddonName() != null && !other.getAddonName().equals(this.getAddonName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getAddonVersions() == null ^ this.getAddonVersions() == null) {
            return false;
        }
        return other.getAddonVersions() == null || other.getAddonVersions().equals(this.getAddonVersions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAddonName() == null ? 0 : this.getAddonName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getAddonVersions() == null ? 0 : this.getAddonVersions().hashCode());
        return hashCode;
    }

    public AddonInfo clone() {
        try {
            return (AddonInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AddonInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

