/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticfilesystem.model.MountTargetDescription;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeMountTargetsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String marker;
    private SdkInternalList<MountTargetDescription> mountTargets;
    private String nextMarker;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeMountTargetsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public List<MountTargetDescription> getMountTargets() {
        if (this.mountTargets == null) {
            this.mountTargets = new SdkInternalList();
        }
        return this.mountTargets;
    }

    public void setMountTargets(Collection<MountTargetDescription> mountTargets) {
        if (mountTargets == null) {
            this.mountTargets = null;
            return;
        }
        this.mountTargets = new SdkInternalList(mountTargets);
    }

    public DescribeMountTargetsResult withMountTargets(MountTargetDescription ... mountTargets) {
        if (this.mountTargets == null) {
            this.setMountTargets((Collection<MountTargetDescription>)new SdkInternalList(mountTargets.length));
        }
        for (MountTargetDescription ele : mountTargets) {
            this.mountTargets.add((Object)ele);
        }
        return this;
    }

    public DescribeMountTargetsResult withMountTargets(Collection<MountTargetDescription> mountTargets) {
        this.setMountTargets(mountTargets);
        return this;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public DescribeMountTargetsResult withNextMarker(String nextMarker) {
        this.setNextMarker(nextMarker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getMountTargets() != null) {
            sb.append("MountTargets: ").append(this.getMountTargets()).append(",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: ").append(this.getNextMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsResult)) {
            return false;
        }
        DescribeMountTargetsResult other = (DescribeMountTargetsResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getMountTargets() == null ^ this.getMountTargets() == null) {
            return false;
        }
        if (other.getMountTargets() != null && !other.getMountTargets().equals(this.getMountTargets())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        return other.getNextMarker() == null || other.getNextMarker().equals(this.getNextMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getMountTargets() == null ? 0 : this.getMountTargets().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        return hashCode;
    }

    public DescribeMountTargetsResult clone() {
        try {
            return (DescribeMountTargetsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

