/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeMountTargetsRequestMarshaller
implements Marshaller<Request<DescribeMountTargetsRequest>, DescribeMountTargetsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeMountTargetsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeMountTargetsRequest> marshall(DescribeMountTargetsRequest describeMountTargetsRequest) {
        if (describeMountTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeMountTargetsRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-02-01/mount-targets";
        request.setResourcePath(uriResourcePath);
        if (describeMountTargetsRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)describeMountTargetsRequest.getMaxItems()));
        }
        if (describeMountTargetsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeMountTargetsRequest.getMarker()));
        }
        if (describeMountTargetsRequest.getFileSystemId() != null) {
            request.addParameter("FileSystemId", StringUtils.fromString((String)describeMountTargetsRequest.getFileSystemId()));
        }
        if (describeMountTargetsRequest.getMountTargetId() != null) {
            request.addParameter("MountTargetId", StringUtils.fromString((String)describeMountTargetsRequest.getMountTargetId()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

