/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.Device;
import java.util.List;

@SdkInternalApi
public class DeviceMarshaller {
    private static final MarshallingInfo<String> HOSTPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hostPath").build();
    private static final MarshallingInfo<String> CONTAINERPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerPath").build();
    private static final MarshallingInfo<List> PERMISSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("permissions").build();
    private static final DeviceMarshaller instance = new DeviceMarshaller();

    public static DeviceMarshaller getInstance() {
        return instance;
    }

    public void marshall(Device device, ProtocolMarshaller protocolMarshaller) {
        if (device == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)device.getHostPath(), HOSTPATH_BINDING);
            protocolMarshaller.marshall((Object)device.getContainerPath(), CONTAINERPATH_BINDING);
            protocolMarshaller.marshall(device.getPermissions(), PERMISSIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

