/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ServiceField;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeServicesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private SdkInternalList<String> services;
    private SdkInternalList<String> include;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public DescribeServicesRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public List<String> getServices() {
        if (this.services == null) {
            this.services = new SdkInternalList();
        }
        return this.services;
    }

    public void setServices(Collection<String> services) {
        if (services == null) {
            this.services = null;
            return;
        }
        this.services = new SdkInternalList(services);
    }

    public DescribeServicesRequest withServices(String ... services) {
        if (this.services == null) {
            this.setServices((Collection<String>)new SdkInternalList(services.length));
        }
        for (String ele : services) {
            this.services.add((Object)ele);
        }
        return this;
    }

    public DescribeServicesRequest withServices(Collection<String> services) {
        this.setServices(services);
        return this;
    }

    public List<String> getInclude() {
        if (this.include == null) {
            this.include = new SdkInternalList();
        }
        return this.include;
    }

    public void setInclude(Collection<String> include) {
        if (include == null) {
            this.include = null;
            return;
        }
        this.include = new SdkInternalList(include);
    }

    public DescribeServicesRequest withInclude(String ... include) {
        if (this.include == null) {
            this.setInclude((Collection<String>)new SdkInternalList(include.length));
        }
        for (String ele : include) {
            this.include.add((Object)ele);
        }
        return this;
    }

    public DescribeServicesRequest withInclude(Collection<String> include) {
        this.setInclude(include);
        return this;
    }

    public DescribeServicesRequest withInclude(ServiceField ... include) {
        SdkInternalList includeCopy = new SdkInternalList(include.length);
        for (ServiceField value : include) {
            includeCopy.add((Object)value.toString());
        }
        if (this.getInclude() == null) {
            this.setInclude((Collection<String>)includeCopy);
        } else {
            this.getInclude().addAll((Collection<String>)includeCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getServices() != null) {
            sb.append("Services: ").append(this.getServices()).append(",");
        }
        if (this.getInclude() != null) {
            sb.append("Include: ").append(this.getInclude());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesRequest)) {
            return false;
        }
        DescribeServicesRequest other = (DescribeServicesRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getServices() == null ^ this.getServices() == null) {
            return false;
        }
        if (other.getServices() != null && !other.getServices().equals(this.getServices())) {
            return false;
        }
        if (other.getInclude() == null ^ this.getInclude() == null) {
            return false;
        }
        return other.getInclude() == null || other.getInclude().equals(this.getInclude());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getServices() == null ? 0 : this.getServices().hashCode());
        hashCode = 31 * hashCode + (this.getInclude() == null ? 0 : this.getInclude().hashCode());
        return hashCode;
    }

    public DescribeServicesRequest clone() {
        return (DescribeServicesRequest)super.clone();
    }
}

